% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/col_schema_match.R
\name{col_schema}
\alias{col_schema}
\title{Generate a table column schema manually or with a reference table}
\usage{
col_schema(..., .tbl = NULL, .db_col_types = c("r", "sql"))
}
\arguments{
\item{...}{A set of named arguments where the names refer to column names and
the values are one or more column types.}

\item{.tbl}{An option to use a table object to define the schema. If this is
provided then any values provided to \code{...} will be ignored. This can either
be a table object, a table-prep formula.This can be a table object such as
a data frame, a tibble, a \code{tbl_dbi} object, or a \code{tbl_spark} object.
Alternatively, a table-prep formula (\verb{~ <table reading code>}) or a
function (\verb{function() <table reading code>}) can be used to lazily read in
the table at interrogation time.}

\item{.db_col_types}{Determines whether the column types refer to R column
types (\code{"r"}) or SQL column types (\code{"sql"}).}
}
\description{
A table column schema object, as can be created by \code{col_schema()}, is
necessary when using the \code{\link[=col_schema_match]{col_schema_match()}} validation function (which
checks whether the table object under study matches a known column schema).
The \code{col_schema} object can be made by carefully supplying the column names
and their types as a set of named arguments, or, we could provide a table
object, which could be of the \code{data.frame}, \code{tbl_df}, \code{tbl_dbi}, or
\code{tbl_spark} varieties. There's an additional option, which is just for
validating the schema of a \code{tbl_dbi} or \code{tbl_spark} object: we can validate
the schema based on R column types (e.g., \code{"numeric"}, \code{"character"}, etc.),
SQL column types (e.g., \code{"double"}, \code{"varchar"}, etc.), or Spark SQL column
types (\code{"DoubleType"}, \code{"StringType"}, etc.). This is great if we want to
validate table column schemas both on the server side and when tabular data
is collected and loaded into R.
}
\section{Function ID}{

13-1
}

\examples{
# Create a simple table with two
# columns: one `integer` and the
# other `character`
tbl <- 
  dplyr::tibble(
    a = 1:5,
    b = letters[1:5]
  )

# Create a column schema object
# that describes the columns and
# their types (in the expected
# order)
schema_obj <- 
  col_schema(
    a = "integer",
    b = "character"
  )

# Validate that the schema object
# `schema_obj` exactly defines
# the column names and column types
# of the `tbl` table
agent <-
  create_agent(tbl = tbl) \%>\%
  col_schema_match(schema_obj) \%>\%
  interrogate()

# Determine if this validation step
# passed by using `all_passed()`
all_passed(agent)

# We can alternatively create
# a column schema object from a
# `tbl_df` object
schema_obj <-
  col_schema(
    .tbl = dplyr::tibble(
      a = integer(0),
      b = character(0)
    )
  )

# This should provide the same
# interrogation results as in the
# previous example
create_agent(tbl = tbl) \%>\%
  col_schema_match(schema_obj) \%>\%
  interrogate() \%>\%
  all_passed()
  
}
\seealso{
Other Utility and Helper Functions: 
\code{\link{affix_datetime}()},
\code{\link{affix_date}()},
\code{\link{from_github}()},
\code{\link{has_columns}()},
\code{\link{stop_if_not}()}
}
\concept{Utility and Helper Functions}
