% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tbl_pb_methods.R
\name{join.tbl_pb}
\alias{join.tbl_pb}
\alias{left_join.tbl_pb}
\alias{inner_join.tbl_pb}
\alias{right_join.tbl_pb}
\alias{full_join.tbl_pb}
\alias{semi_join.tbl_pb}
\alias{nest_join.tbl_pb}
\alias{anti_join.tbl_pb}
\title{Join two pibbles together}
\usage{
\method{left_join}{tbl_pb}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{inner_join}{tbl_pb}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{right_join}{tbl_pb}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{full_join}{tbl_pb}(x, y, by = NULL, copy = FALSE,
  suffix = c(".x", ".y"), ...)

\method{semi_join}{tbl_pb}(x, y, by = NULL, copy = FALSE, ...)

\method{nest_join}{tbl_pb}(x, y, by = NULL, copy = FALSE,
  keep = FALSE, name = NULL, ...)

\method{anti_join}{tbl_pb}(x, y, by = NULL, copy = FALSE, ...)
}
\arguments{
\item{x}{tbls to join}

\item{y}{tbls to join}

\item{by}{a character vector of variables to join by.  If \code{NULL}, the
default, \code{*_join()} will do a natural join, using all variables with
common names across the two tables. A message lists the variables so
that you can check they're right (to suppress the message, simply
explicitly list the variables that you want to join).

To join by different variables on x and y use a named vector.
For example, \code{by = c("a" = "b")} will match \code{x.a} to
\code{y.b}.}

\item{copy}{If \code{x} and \code{y} are not from the same data source,
and \code{copy} is \code{TRUE}, then \code{y} will be copied into the
same src as \code{x}.  This allows you to join tables across srcs, but
it is a potentially expensive operation so you must opt into it.}

\item{suffix}{If there are non-joined duplicate variables in \code{x} and
\code{y}, these suffixes will be added to the output to disambiguate them.
Should be a character vector of length 2.}

\item{...}{other parameters passed onto methods, for instance, \code{na_matches}
to control how \code{NA} values are matched.  See \link{join.tbl_df} for more.}

\item{keep}{If \code{TRUE} the by columns are kept in the nesting joins.}

\item{name}{the name of the list column nesting joins create. If \code{NULL} the name of \code{y} is used.}
}
\description{
These are generic functions that dispatch to individual pibble methods. See  \link[dplyr]{join} for
complete documentation.
}
