% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmdvis.R
\name{pcasf}
\alias{pcasf}
\title{Compare matrices using PCA similarity factor}
\usage{
pcasf(x, y, dim = NULL)
}
\arguments{
\item{x}{Matrix with sample in column and features in row}

\item{y}{Matrix is compared to x.}

\item{dim}{number of retained dimensions in the comparison. Defaults to all.}
}
\value{
Ratio of projected variance to total variance
}
\description{
Compare matrices using PCA similarity factor
}
\examples{
c1 <- matrix(rnorm(16),nrow=4)
c2 <- matrix(rnorm(16),nrow=4)
pcasf(c1, c2)

}
\references{
Singhal, A. and Seborg, D. E. (2005), Clustering multivariate time-series data. J. Chemometrics, 19: 427-438. doi: 10.1002/cem.945
}
\author{
Edgar Zanella Alvarenga
}
