% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmd.R
\name{globalstd}
\alias{globalstd}
\title{GlobalStd algorithm with structure/reaction directed analysis}
\usage{
globalstd(list, rtcutoff = 10, ng = 10, corcutoff = NULL,
  freqcutoff = 10, top = 50, digits = 2, accuracy = 4)
}
\arguments{
\item{list}{a peaks list with mass to charge, retention time and intensity data}

\item{rtcutoff}{cutoff of the distances in cluster, default 10}

\item{ng}{cutoff of global PMD's retention time group numbers}

\item{corcutoff}{cutoff of the correlation coefficient, default NULL}

\item{freqcutoff}{cutoff of frequency of PMDs between RT cluster for independent peaks, default 10}

\item{top}{top n pmd freqency cutoff when the freqcutoff is too small for large data set, default 50}

\item{digits}{mass or mass to charge ratio accuracy for pmd, default 2}

\item{accuracy}{measured mass or mass to charge ratio in digits, default 4}
}
\value{
list with GlobalStd algorithm processed data.
}
\description{
GlobalStd algorithm with structure/reaction directed analysis
}
\examples{
data(spmeinvivo)
re <- globalstd(spmeinvivo)
}
\seealso{
\code{\link{getpaired}},\code{\link{getstd}},\code{\link{getsda}},\code{\link{plotstd}},\code{\link{plotstdsda}},\code{\link{plotstdrt}}
}
