% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cases.R
\name{cases}
\alias{cases}
\title{Dispatches from an expression to a matching pattern}
\usage{
cases(expr, ...)
}
\arguments{
\item{expr}{The value the patterns will be matched against.}

\item{...}{A list of \code{pattern -> expression} statements.}
}
\value{
The value of the expression associated with the first matching
pattern.
}
\description{
Given an expression of a type defined by the \code{\link{:=}} operator,
\code{cases} matches it against patterns until it find one that has the same
structure as \code{expr}. When it does, it evaluates the expression the
pattern is associated with. During matching, any symbol that is not
quasi-quoted will be considered a variable, and matching values will be bound
to such variables and be available when an expression is evaluated.
}
\examples{
linked_list := NIL | CONS(car, cdr : linked_list)
lst <- CONS(1, CONS(2, CONS(3, NIL)))
len <- function(lst, acc = 0) {
    cases(lst,
          NIL -> acc,
          CONS(car,cdr) -> len(cdr, acc + 1))
}
len(lst)

list_sum <- function(lst, acc = 0) {
    cases(lst,
          NIL -> acc,
          CONS(car,cdr) -> list_sum(cdr, acc + car))
}
list_sum(lst)

}
\seealso{
\code{\link{:=}}
}
