% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune_nodes.R
\name{prune_nodes}
\alias{prune_nodes}
\title{Prune nodes based on given percentage}
\usage{
prune_nodes(p, percentage = 0.2, rank = c("amount", "in_degree", "out_degree"))
}
\arguments{
\item{p}{process map object created by \code{create_pmap_graph()} function}

\item{percentage}{how many percentage of the nodes should be pruned.}

\item{rank}{how to rank the nodes.
\code{amount} means ranking the nodes by \code{amount} column (default);
\code{in_degree} means ranking the nodes by \code{in_degree};
\code{out_degree} means ranking the nodes by \code{out_degree};}
}
\description{
Prune nodes based on given percentage
}
\examples{
library(dplyr)
p <- generate_eventlog() \%>\% create_pmap(target_categories = c("target"))
DiagrammeR::count_nodes(p)
# [1] 10
p <- prune_nodes(p, percentage = 0.5)
DiagrammeR::count_nodes(p)
# [1] 5
}
\seealso{
\link{prune_edges}
}
