% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check.R
\name{gamlassoChecks}
\alias{gamlassoChecks}
\title{Checking data before fitting gamlasso}
\usage{
gamlassoChecks(data, response.name, linear.name, smooth.name, family,
  linear.penalty, smooth.penalty, offset.name, weights.name, num.knots,
  num.iter, tolerance, seed, prompts)
}
\arguments{
\item{data}{The training data for fitting the model}

\item{response.name}{The name of the response variable. Vector of two if
\code{family = "binomial"}}

\item{linear.name}{The names of the variables to be used as linear predictors}

\item{smooth.name}{The names of the variables to be used as smoothers}

\item{family}{The family describing the error distribution and link function
to be used in the model. A character string which can only be
\code{"gaussian"} (default), \code{"binomial"}, \code{"poisson"} or
\code{"cox"}. For \code{family = "binomial"}, \code{response} can be
a vector of two and for \code{family="cox"}, \code{weights} must
be provided (see details below).}

\item{linear.penalty}{The penalty used on the linear predictors. Can be 0, 1 or 2}

\item{smooth.penalty}{The penalty used on the smoothers. Can be 1 or 2}

\item{offset.name}{The name of the offset variable. \code{NULL} (default) if not provided}

\item{weights.name}{The name of the weights variable. \code{NULL} (default)
if not provided. See \code{Details} of \code{\link{gamlasso}}.}

\item{num.knots}{Number of knots for each smoothers. Can be a single integer
(recycled for each smoother variable) or a vector of integers the same length
as the number of smoothers.}

\item{num.iter}{Number of iterations for the gamlasso loop}

\item{tolerance}{Tolerance for covergence of the gamlasso loop}

\item{seed}{The random seed can be specified for reproducibility. This is used
for fitting the gam and lasso models, or fixed before each loop of gamlasso.}

\item{prompts}{logical. Should \code{gamlassoChecks} provide interactive
user prompts for corrective action when needed.}
}
\value{
\code{gamlassoChecks} produces a series of logical values:
  \code{allcheck} indicating if the arguments passed all the checks,
  \code{fit.smoothgam} indicating if there aren't any linear predictors and
  a model with only smoothers should be fitted, \code{fit.glmnet}
  is the counterpart for smooth predictors. It also returns the cleaned
  (if needed) arguments as a list named \code{cleandata} who's elements are:

  \tabular{ll}{
    \code{train.data} \tab The training data with unnecessary columns deleted \cr
    \code{linear.name}, \code{smooth.name}, \code{num.knots} \tab The changed
     variable names and number of knots \cr
    \code{linear.penalty}, \code{smooth.penalty} \tab The changed penalties for linear and smooth
    terms. Reset to their default values only
    in the rare case of too few predictors
  }
}
\description{
This function checks if the arguments entered for fitting a gamlasso model
are compatible with each other. Not recommended to call directly. Only use
if cleaning data prior to fitting \code{\link{gamlassoFit}}
}
\note{
The arguments \code{offset.name}, \code{num.iter}, \code{tolerance}
  and \code{seed} are not currently not being used in testing.
}
\examples{
## Usage similar to gamlassoFit
}
