% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stdize.R
\name{stdize}
\alias{stdize}
\alias{predict.stdized}
\alias{makepredictcall.stdized}
\title{Standardization of Data Matrices}
\usage{
stdize(x, center = TRUE, scale = TRUE)

\method{predict}{stdized}(object, newdata, ...)

\method{makepredictcall}{stdized}(var, call)
}
\arguments{
\item{x, newdata}{numeric matrices.  The data to standardize.}

\item{center}{logical value or numeric vector of length equal to the number
of coloumns of \code{x}.}

\item{scale}{logical value or numeric vector of length equal to the number
of coloumns of \code{x}.}

\item{object}{an object inheriting from class \code{"stdized"}, normally the
result of a call to \code{stdize}.}

\item{\dots}{other arguments.  Currently ignored.}

\item{var}{A variable.}

\item{call}{The term in the formula, as a call.}
}
\value{
Both \code{stdize} and \code{predict.stdized} return a scaled and/or
centered matrix, with attributes \code{"stdized:center"} and/or
\code{"stdized:scale"} the vector used for centering and/or scaling.  The
matrix is given class \code{c("stdized", "matrix")}.
}
\description{
Performs standardization (centering and scaling) of a data matrix.
}
\details{
\code{makepredictcall.stdized} is an internal utility function; it is not
meant for interactive use.  See \code{\link{makepredictcall}} for details.

If \code{center} is \code{TRUE}, \code{x} is centered by subtracting the
coloumn mean from each coloumn.  If \code{center} is a numeric vector, it is
used in place of the coloumn means.

If \code{scale} is \code{TRUE}, \code{x} is scaled by dividing each coloumn
by its sample standard deviation.  If \code{scale} is a numeric vector, it
is used in place of the standard deviations.
}
\note{
\code{stdize} is very similar to \code{\link[base]{scale}}.  The
difference is that when \code{scale = TRUE}, \code{stdize} divides the
coloumns by their standard deviation, while \code{scale} uses the
root-mean-square of the coloumns.  If \code{center} is \code{TRUE}, this is
equivalent, but in general it is not.
}
\examples{

data(yarn)
## Direct standardization:
Ztrain <- stdize(yarn$NIR[yarn$train,])
Ztest <- predict(Ztrain, yarn$NIR[!yarn$train,])

## Used in formula:
mod <- plsr(density ~ stdize(NIR), ncomp = 6, data = yarn[yarn$train,])
pred <- predict(mod, newdata = yarn[!yarn$train,]) # Automatically standardized

}
\seealso{
\code{\link{mvr}}, \code{\link{pcr}}, \code{\link{plsr}},
\code{\link{msc}}, \code{\link[base]{scale}}
}
\author{
Bjørn-Helge Mevik and Ron Wehrens
}
\keyword{multivariate}
\keyword{regression}
