% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{GSEAPlotAtomic}
\alias{GSEAPlotAtomic}
\title{GSEA plot for a single term}
\usage{
GSEAPlotAtomic(
  data,
  gene_ranks = "@gene_ranks",
  gs,
  genes,
  metric = "p.adjust",
  sample_coregenes = FALSE,
  line_width = 1.5,
  line_alpha = 1,
  line_color = "#6BB82D",
  n_coregenes = 10,
  genes_label = NULL,
  label_fg = "black",
  label_bg = "white",
  label_bg_r = 0.1,
  label_size = 4,
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame.}

\item{gene_ranks}{A numeric vector of gene ranks with genes as names
The gene ranks are used to plot the gene sets.
If \code{gene_ranks} is a character vector starting with \code{@}, the gene ranks will be taken from the attribute of \code{data}.}

\item{gs}{The name of the gene set}

\item{genes}{The genes in the gene set}

\item{metric}{The metric to show in the subtitle}

\item{sample_coregenes}{A logical value to sample the core genes from the core_enrichment; if \code{FALSE}, the first \code{n_coregenes} will be used}

\item{line_width}{The width of the line in the running score plot}

\item{line_alpha}{The alpha of the line in the running score plot}

\item{line_color}{The color of the line in the running score plot}

\item{n_coregenes}{The number of core genes to label}

\item{genes_label}{The genes to label. If set, \code{n_coregenes} will be ignored}

\item{label_fg}{The color of the label text}

\item{label_bg}{The background color of the label}

\item{label_bg_r}{The radius of the background color of the label}

\item{label_size}{The size of the label text}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{The label of the y-axis, will be shown on the right side}

\item{...}{Additional arguments.}
}
\description{
GSEA plot for a single term
}
\keyword{internal}
