% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrich.R
\name{EnrichNetworkAtomic}
\alias{EnrichNetworkAtomic}
\title{Atomic Enrichment Network}
\usage{
EnrichNetworkAtomic(
  data,
  top_term = 6,
  metric = "p.adjust",
  character_width = 50,
  layout = "fr",
  layoutadjust = TRUE,
  adjscale = 60,
  adjiter = 100,
  blendmode = "blend",
  labelsize = 5,
  theme = "theme_this",
  theme_args = list(),
  palette = "Paired",
  palcolor = NULL,
  alpha = 1,
  aspect.ratio = 1,
  legend.position = "right",
  legend.direction = "vertical",
  title = NULL,
  subtitle = NULL,
  xlab = NULL,
  ylab = NULL,
  seed = 8525,
  ...
)
}
\arguments{
\item{data}{A data frame containing the data to be plotted.}

\item{layoutadjust}{A logical value specifying whether to adjust the layout of the network.}

\item{adjscale}{A numeric value specifying the scale of the adjustment.}

\item{adjiter}{A numeric value specifying the number of iterations for the adjustment.}

\item{blendmode}{A character string specifying the blend mode of the colors.
Either "blend", "average", "multiply" and "screen".}

\item{theme}{A character string or a theme class (i.e. ggplot2::theme_classic) specifying the theme to use.
Default is "theme_this".}

\item{theme_args}{A list of arguments to pass to the theme function.}

\item{palette}{A character string specifying the palette to use.
A named list or vector can be used to specify the palettes for different \code{split_by} values.}

\item{palcolor}{A character string specifying the color to use in the palette.
A named list can be used to specify the colors for different \code{split_by} values.
If some values are missing, the values from the palette will be used (palcolor will be NULL for those values).}

\item{alpha}{A numeric value specifying the transparency of the plot.}

\item{aspect.ratio}{A numeric value specifying the aspect ratio of the plot.}

\item{legend.position}{A character string specifying the position of the legend.
if \code{waiver()}, for single groups, the legend will be "none", otherwise "right".}

\item{legend.direction}{A character string specifying the direction of the legend.}

\item{title}{A character string specifying the title of the plot.
A function can be used to generate the title based on the default title.
This is useful when split_by is used and the title needs to be dynamic.}

\item{subtitle}{A character string specifying the subtitle of the plot.}

\item{xlab}{A character string specifying the x-axis label.}

\item{ylab}{A character string specifying the y-axis label.}

\item{seed}{The random seed to use. Default is 8525.}

\item{...}{Additional arguments.}
}
\value{
A ggplot object
}
\description{
Atomic Enrichment Network
}
\keyword{internal}
