% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rotatexy.R
\name{rotatexy}
\alias{rotatexy}
\title{Rotation Transformation}
\usage{
rotatexy(x, angle = pi/4, xmiddle = 0, ymiddle = 0, f = NULL,
  group = TRUE, todf = TRUE, checks = TRUE)
}
\arguments{
\item{x}{the input. It can be a data frame, matrix, tibble object, 
or a list of 
these kinds of objects. Each object must have exactly 2 columns 
and must be numeric without NA.}

\item{angle}{default is pi/4. The rotation angle in radian.
Note: "radian = degree * pi / 180". Its length can be 
larger than 1.
The rotation direction is anti-clockwise.}

\item{xmiddle}{the x coordinates of rotation centers.
Its length can be 
larger than 1.}

\item{ymiddle}{the y coordinates of rotation centers.
Its length can be 
larger than 1.}

\item{f}{argument passed to \code{split} to divide a data frame 
into a list of data frames. It should be a vector whose length is 
equal to the number of rows of x (if x is a data frame).}

\item{group}{default is TRUE. It indicates 
whether to add a 3rd column named 
"d" to label the group number of each group of points. It is useful 
when using \code{aes(...group=g)} with 'ggplot2'.}

\item{todf}{default is TRUE. It indicates whether to 
combine the output (a list) into a data frame.}

\item{checks}{default is TRUE. It indicates whether 
to check input validity. Do not turn it off unless you are sure 
that the input is OK.}
}
\value{
if \code{todf = TRUE}, the output will be a data frame
with coordinates of possibly several polygons, otherwise, 
it will be a list of data frames. Data frames have 2 columns
named "x" and "y", and if \code{group = TRUE}, a third column 
named "g" is added indicating group numbers.
}
\description{
A2 (output) is the result of rotating A1 (input) 
around a point.
Note: the two shapes look 
the same (though with different angles) 
only when \code{ggplot2::coord_fixed()} is used.
}
\examples{
library(ggplot2)
dat1=data.frame(x=c(0, 4, 4, 0), y=c(0, 0, 2, 2))
dat2=data.frame(x=c(5, 6, 6, 5), y=c(4, 4, 8, 8))
dat3=rotatexy(list(dat1, dat2), angle=c(pi, pi/4), 
	xmiddle=c(0, 5), ymiddle=c(0, 4), todf=TRUE)
ggplot()+
	coord_fixed()+
	geom_polygon(data=dat1, aes(x=x, y=y), fill="red", alpha=0.2)+
	geom_polygon(data=dat2, aes(x=x, y=y), fill="blue", alpha=0.2)+
	geom_polygon(show.legend=FALSE, data=dat3, 
		aes(x=x, y=y, group=g, fill=factor(g)), alpha=0.2)
}
