% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{multi_ggroc}
\alias{multi_ggroc}
\title{Plot multiple ROC curves}
\usage{
multi_ggroc(datalist, fpf_string = rep("FPF", length(datalist)),
  tpf_string = rep("TPF", length(datalist)), c_string = rep("c",
  length(datalist)), label = NULL, legend = TRUE, label.adj.x = rep(0,
  length(datalist)), label.adj.y = rep(0, length(datalist)),
  label.angle = rep(45, length(datalist)), plotmath = FALSE,
  xlabel = "False positive fraction", ylabel = "True positive fraction")
}
\arguments{
\item{datalist}{List of data frames each containing true and false positive
fractions and cutoffs}

\item{fpf_string}{Column names identifying false positive fraction}

\item{tpf_string}{Column names identifying true positive fraction}

\item{c_string}{Column names identifying cutoff values}

\item{label}{Not supported.}

\item{legend}{If true, draws legend}

\item{label.adj.x}{Not supported.}

\item{label.adj.y}{Not supported.}

\item{label.angle}{Not supported.}

\item{plotmath}{Logical. Not supported.}

\item{xlabel}{Defaults to "False positive fraction"}

\item{ylabel}{Defaults to "True positive fraction"}
}
\value{
A ggplot object
}
\description{
Given a list of results computed by \link{calculate_roc}, plot the curve
using ggplot with sensible defaults. Pass the resulting object and data to
\link{export_interactive_roc}, \link{plot_interactive_roc}, or
\link{plot_journal_roc}.
}
