% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/calculate_roc.R
\name{calculate_multi_roc}
\alias{calculate_multi_roc}
\title{Calculate the Empirical ROC curves for multiple biomarkers}
\usage{
calculate_multi_roc(data, M_string, D_string)
}
\arguments{
\item{data}{data frame containing at least 1 marker and the common class
labels, coded as 0 and 1}

\item{M_string}{vector of marker column names}

\item{D_string}{class label column name}
}
\value{
List of data frames containing cutoffs, and estimated true and false
  positive fractions
}
\description{
Calculate empirical ROC curve estimates given labels and predictions. Designed to work with the
\code{multi_ggroc} function, this takes a \code{data.frame} and computes the ROC
curve for a given list of markers.
}
\examples{
D.ex <- rbinom(100, 1, .5)
fakedata <- data.frame(M1 = rnorm(100, mean = D.ex),
   M2 = rnorm(100, mean = D.ex, sd = .4), D = D.ex)
calculate_multi_roc(fakedata, c("M1", "M2"), "D")
}

