\name{kml_legend.bar}
\alias{kml_legend.bar}
\title{Generates a legend bar (PNG file)}
\description{Produces a PNG file that can be used as a screen overlay --- legend bar for numeric and factor type variables.}
\usage{
kml_legend.bar(x, width, height, pointsize = 14, legend.file, legend.pal, 
         z.lim = range(x, na.rm=TRUE, finite=TRUE), factor.labels)
}
\arguments{
  \item{x}{numeric or factor-type vector}
  \item{width}{numeric; (optional) width of image in pixels}
  \item{height}{numeric; (optional) height of image in pixels}
  \item{pointsize}{numeric; point size for the plot}
  \item{legend.file}{PNG file name}
  \item{legend.pal}{character; color palette}
  \item{z.lim}{numeric; lower and upper limits}
  \item{factor.labels}{character; class names if applicable}
}
\author{Tomislav Hengl, Pierre Roudier, and Dylan Beaudette}
\details{When exporting raster layers to KML the legend bar is generated by default. If the width and height are not provided, the function will try to estimate them automatically.}
\seealso{ \code{grDevices::png}, \code{\link{kml-methods}}, \code{\link{kml_layer}} }
\keyword{spatial}