% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtern.R
\name{stat_field3logit}
\alias{stat_field3logit}
\title{Add a field to a \code{gg3logit} plot}
\usage{
stat_field3logit(
  mapping = aes(),
  data = NULL,
  geom = "segment",
  position = "identity",
  show.legend = NA,
  inherit.aes = TRUE,
  arrow. = arrow(length = unit(0.2, "cm")),
  ...
)
}
\arguments{
\item{mapping}{list of aesthetic mappings to be used for plot. Mandatory
aesthetics should not be specified if \code{field3loglit} or \code{multifield3logit}
object is passed to \code{data}. See secion \strong{Aesthetic mappings} of
\code{\link[=gg3logit]{gg3logit()}} for details.}

\item{data}{a \code{field3logit} object, a \code{multifield3logit} object, or
a \code{data.frame} structured like a fortified \code{field3logit} or a
\code{multifield3logit} object.}

\item{geom}{The geometric object to use to display the data, either as a
\code{ggproto} \code{Geom} subclass or as a string naming the geom stripped of the
\code{geom_} prefix (e.g. \code{"point"} rather than \code{"geom_point"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{arrow.}{specification for arrow heads, as created by
function \code{\link[grid:arrow]{arrow}} of package \code{\link[grid:grid-package]{grid}}.}

\item{...}{additional arguments passed through to \code{\link[ggtern:ggtern]{ggtern}}.}
}
\value{
Layer of \code{ggplot2} package, object of class \code{LayerInstance}.
}
\description{
\code{\link[=stat_field3logit]{stat_field3logit()}} adds a field to a \code{\link{gg3logit}} plot.
}
\examples{
\donttest{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ gender + finalgrade, data = cross_1year)
field0 <- field3logit(mod0, 'genderFemale', conf = 0.95)

gg3logit(field0) + stat_field3logit()
gg3logit(field0) + stat_field3logit() + stat_conf3logit()
}

}
\seealso{
Other gg functions: 
\code{\link{autoplot.Hfield3logit}()},
\code{\link{gg3logit}()},
\code{\link{stat_3logit}()},
\code{\link{stat_conf3logit}()}
}
\concept{gg functions}
