% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multifield3logit.R
\name{multifield3logit}
\alias{multifield3logit}
\alias{+.field3logit}
\alias{print.multifield3logit}
\alias{fortify.multifield3logit}
\title{Multiple trilogit fields}
\usage{
multifield3logit(x, ...)

\method{+}{field3logit}(x, y)

\method{print}{multifield3logit}(x, maxitems = 10, ...)

\method{fortify}{multifield3logit}(model, ...)
}
\arguments{
\item{x, y}{object of class \code{field3logit} or \code{multifield3logit}.}

\item{...}{other arguments passed to or from other methods.}

\item{maxitems}{maximum number of items to be enumerated when an object of
class \code{multifield3logit} is printed.}

\item{model}{either a fitted trinomial model or a matrix of regressor
coefficients. See section \emph{Compatibility} and examples of
\code{\link{plot3logit-package}}.}
}
\value{
\code{S3} object of class \code{multifield3logit} structured as a named \code{list}.
}
\description{
Methods of \code{S3} class \code{multifield3logit} handle multiple \code{fields3logit}
objects simultaneously and permit new \code{multifield3logit} object to be
easily created by means of the sum operator \code{+}. The \code{\link{fortify}} method
of \code{multifield3logit} permits multiple \code{field3logit} objects to be easily
handled by \code{\link{gg3logit}} and \code{ggtern}-based functions and methods. See
Examples.
}
\examples{
data(cross_1year)

mod0 <- nnet::multinom(employment_sit ~ ., data = cross_1year)
mod0

field_Sdur <- field3logit(mod0, 'durationShort',
  label = 'Short duration')
field_Hfgr <- field3logit(mod0, 'finalgradeHigh',
  label = 'High final grade')

gg3logit(field_Sdur + field_Hfgr) +
  stat_3logit() +
  facet_wrap(~ label)

refpoint <- list(c(0.7, 0.15, 0.15))

field_Sdur <- field3logit(mod0, 'durationShort',
  label = 'Short duration', p0 = refpoint, narrows = 1)
field_Ldur <- field3logit(mod0, 'durationLong',
  label = 'Long duration', p0 = refpoint, narrows = 1)
field_Hfgr <- field3logit(mod0, 'finalgradeHigh',
  label = 'High final grade', p0 = refpoint, narrows = 1)
field_Lfgr <- field3logit(mod0, 'finalgradeLow',
  label = 'Low final grade', p0 = refpoint, narrows = 1)

mfields <- field_Sdur + field_Ldur  + field_Lfgr + field_Hfgr
mfields

gg3logit(mfields) +
  stat_3logit(aes(colour = label)) +
  theme_zoom_L(0.45)

}
\seealso{
\code{\link{field3logit}}.

Other `gg` functions: \code{\link{gg3logit}},
  \code{\link{stat_3logit}}
}
\concept{`gg` functions}
