% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute_snp_data.R
\name{impute_snp_data}
\alias{impute_snp_data}
\title{A function to impute SNP data}
\usage{
impute_snp_data(
  obj,
  X,
  impute,
  impute_method,
  parallel,
  outfile,
  quiet,
  seed = as.numeric(Sys.Date()),
  ...
)
}
\arguments{
\item{obj}{a \code{bigSNP} object (as created by \code{read_plink_files()})}

\item{X}{A matrix of genotype data as  returned by \code{name_and_count_bigsnp}}

\item{impute}{Logical: should data be imputed? Default to TRUE.}

\item{impute_method}{If 'impute' = TRUE, this argument will specify the kind of imputation desired. Options are:
\itemize{
\item mode (default): Imputes the most frequent call. See \code{bigsnpr::snp_fastImputeSimple()} for details.
\item random: Imputes sampling according to allele frequencies.
\item mean0: Imputes the rounded mean.
\item mean2: Imputes the mean rounded to 2 decimal places.
\item xgboost: Imputes using an algorithm based on local XGBoost models. See \code{bigsnpr::snp_fastImpute()} for details. Note: this can take several minutes, even for a relatively small data set.
}}

\item{parallel}{Logical: should the computations within this function be run in parallel? Defaults to TRUE. See \code{count_cores()} and \code{?bigparallelr::assert_cores} for more details.
In particular, the user should be aware that too much parallelization can make computations \emph{slower}.}

\item{outfile}{Optional: the name (character string) of the prefix of the logfile to be written. Defaults to 'process_plink', i.e. you will get 'process_plink.log' as the outfile.}

\item{quiet}{Logical: should messages be printed to the console? Defaults to TRUE}

\item{seed}{Numeric value to be passed as the seed for \code{impute_method = 'xgboost'}. Defaults to \code{as.numeric(Sys.Date())}}

\item{...}{Optional: additional arguments to \code{bigsnpr::snp_fastImpute()} (relevant only if impute_method = "xgboost")}
}
\value{
Nothing is returned, but the \code{obj$genotypes} is overwritten with the imputed version of the data
}
\description{
A function to impute SNP data
}
\keyword{internal}
