% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_general.R
\name{plmtest}
\alias{plmtest}
\alias{plmtest.plm}
\alias{plmtest.formula}
\title{Lagrange FF Multiplier Tests for Panel Models}
\usage{
plmtest(x, ...)

\method{plmtest}{plm}(x, effect = c("individual", "time", "twoways"),
  type = c("honda", "bp", "ghm", "kw"), ...)

\method{plmtest}{formula}(x, data, ..., effect = c("individual", "time",
  "twoways"), type = c("honda", "bp", "ghm", "kw"))
}
\arguments{
\item{x}{an object of class \code{"plm"} or a formula of class
\code{"formula"},}

\item{\dots}{further arguments passed to \code{plmtest}.}

\item{effect}{a character string indicating which effects are
tested: individual effects (\code{"individual"}), time effects
(\code{"time"}) or both (\code{"twoways"}),}

\item{type}{a character string indicating the test to be performed:
\itemize{
\item \code{"honda"} (default) for \insertCite{HOND:85;textual}{plm},
\item \code{"bp"} for \insertCite{BREU:PAGA:80;textual}{plm},
\item \code{"kw"} for \insertCite{KING:WU:97;textual}{plm}, or
\item \code{"ghm"} for \insertCite{GOUR:HOLL:MONF:82;textual}{plm} for
unbalanced panel data sets, the respective unbalanced version
of the tests are computed,
}}

\item{data}{a \code{data.frame},}
}
\value{
An object of class \code{"htest"}.
}
\description{
Test of individual and/or time effects for panel models.
}
\details{
These Lagrange multiplier tests use only the residuals of the
pooling model.  The first argument of this function may be either a
pooling model of class \code{plm} or an object of class \code{formula}
describing the model. For inputted within (fixed effects) or random
effects models, the corresponding pooling model is calculated
internally first as the tests are based on the residuals of the
pooling model.

The \code{"bp"} test for unbalanced panels was derived in
\insertCite{BALT:LI:90;textual}{plm}
(1990), the \code{"kw"} test for unbalanced panels in
\insertCite{BALT:CHAN:LI:98;textual}{plm}.

The \code{"ghm"} test and the \code{"kw"} test were extended to two-way
effects in \insertCite{BALT:CHAN:LI:92;textual}{plm}.

For a concise overview of all these statistics see
\insertCite{BALT:03;textual}{plm}, Sec. 4.2, pp. 68--76 (for balanced
panels) and Sec. 9.5, pp. 200--203 (for unbalanced panels).
}
\note{
For the King-Wu statistics (\code{"kw"}), the oneway statistics
(\code{"individual"} and \code{"time"}) coincide with the respective
Honda statistics (\code{"honda"}); twoway statistics of \code{"kw"} and
\code{"honda"} differ.
}
\examples{

data("Grunfeld", package = "plm")
g <- plm(inv ~ value + capital, data = Grunfeld, model = "pooling")
plmtest(g)
plmtest(g, effect="time")
plmtest(inv ~ value + capital, data = Grunfeld, type = "honda")
plmtest(inv ~ value + capital, data = Grunfeld, type = "bp")
plmtest(inv ~ value + capital, data = Grunfeld, type = "bp",  effect = "twoways")
plmtest(inv ~ value + capital, data = Grunfeld, type = "ghm", effect = "twoways")
plmtest(inv ~ value + capital, data = Grunfeld, type = "kw",  effect = "twoways")

Grunfeld_unbal <- Grunfeld[1:(nrow(Grunfeld)-1), ] # create an unbalanced panel data set
g_unbal <- plm(inv ~ value + capital, data = Grunfeld_unbal, model = "pooling")
plmtest(g_unbal) # unbalanced version of test is indicated in output

}
\references{
\insertRef{BALT:13}{plm}

\insertRef{BALT:LI:90}{plm}

\insertRef{BALT:CHAN:LI:92}{plm}

\insertRef{BALT:CHAN:LI:98}{plm}

\insertRef{BREU:PAGA:80}{plm}

\insertRef{GOUR:HOLL:MONF:82}{plm}

\insertRef{HOND:85}{plm}

\insertRef{KING:WU:97}{plm}
}
\seealso{
\code{\link[=pFtest]{pFtest()}} for individual and/or time effects tests based
on the within model.
}
\author{
Yves Croissant (initial implementation), Kevin Tappe
(generalization to unbalanced panels)
}
\keyword{htest}
