% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shapefile.R
\name{utils_shapefile}
\alias{utils_shapefile}
\alias{shapefile_input}
\alias{shapefile_export}
\alias{shapefile_view}
\title{Import/export shapefiles.}
\usage{
shapefile_input(
  shapefile,
  info = TRUE,
  as_sf = TRUE,
  multilinestring = FALSE,
  ...
)

shapefile_export(shapefile, filename, ...)

shapefile_view(
  shapefile,
  attribute = NULL,
  type = c("shape", "centroid"),
  color_regions = custom_palette(c("red", "yellow", "forestgreen")),
  ...
)
}
\arguments{
\item{shapefile}{For \code{shapefile_input()}, character (filename), or an object that can be
coerced to a SpatVector, such as an \code{sf} (simple features) object. See
\code{\link[terra:vect]{terra::vect()}} for more details.

For \code{shapefile_export()}, a \code{SpatVector} or an \code{sf} object to be exported as
a shapefile.}

\item{info}{Logical value indicating whether to print information about the
imported shapefile (default is \code{TRUE}).}

\item{as_sf}{Logical value indicating whether to convert the imported
shapefile to an \code{sf} object (default is \code{TRUE}).}

\item{multilinestring}{Logical value indicating whether to cast polygon geometries
to \code{MULTILINESTRING} geometries (default is \code{FALSE}).}

\item{...}{Additional arguments to be passed to \code{\link[terra:vect]{terra::vect()}}
(\code{shapefile_input()}), \code{\link[terra:writeVector]{terra::writeVector()}} (\code{shapefile_export()}) or
\code{\link[mapview:mapView]{mapview::mapview()}} (\code{shapefile_view()}).}

\item{filename}{The path to the output shapefile.}

\item{attribute}{The attribute to be shown in the color key. It must be a
variable present in \code{shapefile}.}

\item{type}{A character string specifying whether to visualize the shapefile
as \code{"shape"} or as \code{"centroid"}. Partial matching is allowed. If set to
\code{"centroid"}, the function will convert the shapefile's geometry to
centroids before displaying. Defaults to \code{"shape"}.}

\item{color_regions}{The color palette to represent \code{attribute}.}
}
\value{
\itemize{
\item \code{shapefile_input()} returns an object of class \code{sf} (default) representing
the imported shapefile.
\item \code{shapefile_export()} returns a \code{NULL} object.
\item \code{shapefile_view()} returns an object of class \code{mapview}.
}
}
\description{
\itemize{
\item \code{shapefile_input()} creates or imports a shapefile and optionally converts
it to an \code{sf} object. It can also cast \code{POLYGON} or \code{MULTIPOLYGON} geometries
to \code{MULTILINESTRING} if required.
\item \code{shapefile_export()} exports an object (\code{sf} or \code{SpatVector}) to a file.
\item \code{shapefile_view()} is a simple wrapper around \code{mapview()} to plot a shapefile.
}
}
\examples{
if(interactive()){
library(pliman)
shp <- system.file("ex/lux.shp", package="terra")
shp_file <- shapefile_input(shp, as_sf = FALSE)
shapefile_view(shp_file)
}

}
