% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{object_rgb}
\alias{object_rgb}
\title{Extract red, green and blue values from objects}
\usage{
object_rgb(img, labels)
}
\arguments{
\item{img}{An \code{Image} object}

\item{labels}{A mask containing the labels for each object. This can be
obtained with \code{\link[EBImage:bwlabel]{EBImage::bwlabel()}} or \code{\link[EBImage:watershed]{EBImage::watershed()}}}
}
\value{
A data.frame with \code{n} rows (number of pixels for all the objects) and
the following columns:
\itemize{
\item \code{id}: the object id;
\item \code{R}: the value for the red band;
\item \code{G}: the value for the blue band;
\item \code{B}: the value for the green band;
}
}
\description{
Given an image and a matrix of labels that identify each object, the function
extracts the red, green, and blue values from each object.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("soybean_touch.jpg")
# segment the objects using the "B" (blue) band (default)

labs <- object_label(img, watershed = TRUE)
rgb <- object_rgb(img, labs[[1]])
head(rgb)
}
}
