% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{object_mark}
\alias{object_mark}
\title{Mark Object Points}
\usage{
object_mark(object, col = "white")
}
\arguments{
\item{object}{An \code{anal_obj} object computed with \code{analyze_objects_shp()} or
\code{analyze_objects_shp()}.}

\item{col}{The color of the marked points. Default is "white".}
}
\description{
Marks the coordinates of objects in an \code{anal_obj} object on a plot.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
flax <- image_pliman("flax_leaves.jpg", plot =TRUE)
res <-
   analyze_objects(flax,
                       watershed = FALSE,
                       index = "R/(G/B)",
                       plot = FALSE)
object_mark(res)
}
}
\seealso{
\code{\link{analyze_objects_shp}}
}
