% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_file.R
\name{leading_zeros}
\alias{leading_zeros}
\title{Add leading zeros to a numeric sequence}
\usage{
leading_zeros(x, n = 3)
}
\arguments{
\item{x}{A numeric vector or a list of numeric vectors.}

\item{n}{The number of leading zeros to add. Defaults to \code{3}.}
}
\value{
A character vector or a list of character vectors.
}
\description{
Add \code{n} leading zeros to a numeric sequence. This is useful to create a
character vector to rename files in a folder.
}
\examples{
library(pliman)
leading_zeros(1:5)
leading_zeros(list(a = 1:3,
                   b = 1:5),
              n = 2)
}
