% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shp.R
\name{analyze_objects_shp}
\alias{analyze_objects_shp}
\title{Analyzes objects using shapefiles}
\usage{
analyze_objects_shp(
  img,
  nrow = 1,
  ncol = 1,
  buffer_x = 0,
  buffer_y = 0,
  prepare = FALSE,
  segment_objects = TRUE,
  viewer = get_pliman_viewer(),
  index = "R",
  r = 1,
  g = 2,
  b = 3,
  re = 4,
  nir = 5,
  shapefile = NULL,
  interactive = FALSE,
  plot = FALSE,
  parallel = FALSE,
  workers = NULL,
  watershed = TRUE,
  opening = FALSE,
  closing = FALSE,
  filter = FALSE,
  erode = FALSE,
  dilate = FALSE,
  object_size = "medium",
  efourier = FALSE,
  object_index = NULL,
  veins = FALSE,
  width_at = FALSE,
  verbose = TRUE,
  invert = FALSE,
  ...
)
}
\arguments{
\item{img}{An \code{Image} object}

\item{nrow, ncol}{The number of rows and columns to generate the shapefile
when \code{shapefile} is not declared. Defaults to \code{1}.}

\item{buffer_x, buffer_y}{Buffering factor for the width and height,
respectively, of each individual shape's side. A value between 0 and 0.5 where 0
means no buffering and 0.5 means complete buffering (default: 0). A value of
0.25 will buffer the shape by 25\% on each side.}

\item{prepare}{Logical value indicating whether to prepare the image for
analysis using \code{\link[=image_prepare]{image_prepare()}} function. Defaults to \code{FALSE}. Set to
\code{TRUE} to interactively align and crop the image before processing.}

\item{segment_objects}{Segment objects in the image? Defaults to \code{TRUE}. In
this case, objects are segmented using the index defined in the \code{index}
argument, and each object is analyzed individually. If \code{segment_objects = FALSE} is used, the objects are not segmented and the entire image is
analyzed. This is useful, for example, when analyzing an image without
background, where an \code{object_index} could be computed for the entire image,
like the index of a crop canopy.}

\item{viewer}{The viewer option. If not provided, the value is retrieved
using \code{\link[=get_pliman_viewer]{get_pliman_viewer()}}. This option controls the type of viewer to use
for interactive plotting. The available options are "base" and "mapview".
If set to "base", the base R graphics system is used for interactive
plotting. If set to "mapview", the mapview package is used. To set this
argument globally for all functions in the package, you can use the
\code{\link[=set_pliman_viewer]{set_pliman_viewer()}} function. For example, you can run
\code{set_pliman_viewer("mapview")} to set the viewer option to "mapview" for
all functions.}

\item{index}{A character value specifying the target mode for conversion to
binary image when \code{foreground} and \code{background} are not declared. Defaults
to \code{"NB"} (normalized blue). See \code{\link[=image_index]{image_index()}} for more details. User can
also calculate your own index using the bands names, e.g. \code{index = "R+B/G"}}

\item{r, g, b, re, nir}{The red, green, blue, red-edge, and near-infrared bands
of the image, respectively. Defaults to 1, 2, 3, 4, and 5, respectively. If
a multispectral image is provided (5 bands), check the order of bands,
which are frequently presented in the 'BGR' format.}

\item{shapefile}{(Optional) An object created with \code{\link[=image_shp]{image_shp()}}. If \code{NULL}
(default), both \code{nrow} and \code{ncol} must be declared.}

\item{interactive}{If \code{FALSE} (default) the grid is created automatically
based on the image dimension and number of nrow/columns. If \code{interactive = TRUE}, users must draw points at the diagonal of the desired bounding box
that will contain the grid.}

\item{plot}{Plots the processed images? Defaults to \code{FALSE}.}

\item{parallel}{If \code{TRUE} processes the images asynchronously (in parallel) in
separate R sessions running in the background on the same machine. It may
speed up the processing time, especially when \code{pattern} is used is informed.
When \code{object_index} is informed, multiple sections will be used to extract
the RGB values for each object in the image. This may significantly speed up
processing time when an image has lots of objects (say >1000).}

\item{workers}{A positive numeric scalar or a function specifying the number
of parallel processes that can be active at the same time. By default, the
number of sections is set up to 30\% of available cores.}

\item{watershed}{If \code{TRUE} (default) performs watershed-based object
detection. This will detect objects even when they are touching one other.
If \code{FALSE}, all pixels for each connected set of foreground pixels are set
to a unique object. This is faster but is not able to segment touching
objects.}

\item{opening, closing, filter, erode, dilate}{\strong{Morphological operations (brush size)}
\itemize{
\item \code{dilate} puts the mask over every background pixel, and sets it to
foreground if any of the pixels covered by the mask is from the foreground.
\item \code{erode} puts the mask over every foreground pixel, and sets it to
background if any of the pixels covered by the mask is from the background.
\item \code{opening} performs an erosion followed by a dilation. This helps to
remove small objects while preserving the shape and size of larger objects.
\item \code{closing} performs a dilatation followed by an erosion. This helps to
fill small holes while preserving the shape and size of larger objects.
\item \code{filter} performs median filtering in the binary image. Provide a positive
integer > 1 to indicate the size of the median filtering. Higher values are
more efficient to remove noise in the background but can dramatically impact
the perimeter of objects, mainly for irregular perimeters such as leaves
with serrated edges.
}}

\item{object_size}{Argument to control control the watershed segmentation.
See \code{\link[=analyze_objects]{analyze_objects()}} for more details.}

\item{efourier}{Logical argument indicating if Elliptical Fourier should be
computed for each object. This will call \code{\link[=efourier]{efourier()}} internally. It
\code{efourier = TRUE} is used, both standard and normalized Fourier coefficients
are returned.}

\item{object_index}{Defaults to \code{FALSE}. If an index is informed, the average
value for each object is returned. It can be the R, G, and B values or any
operation involving them, e.g., \code{object_index = "R/B"}. In this case, it
will return for each object in the image, the average value of the R/B
ratio. Use \code{\link[=pliman_indexes_eq]{pliman_indexes_eq()}} to see the equations of available indexes.}

\item{veins}{Logical argument indicating whether vein features are computed.
This will call \code{\link[=object_edge]{object_edge()}} and applies the Sobel-Feldman Operator to
detect edges. The result is the proportion of edges in relation to the
entire area of the object(s) in the image. Note that \strong{THIS WILL BE AN
OPERATION ON AN IMAGE LEVEL, NOT OBJECT!}.}

\item{width_at}{Logical. If \code{TRUE}, the widths of the object at a given set
of quantiles of the height are computed.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{invert}{Inverts the binary image if desired. This is useful to process
images with a black background. Defaults to \code{FALSE}. If \code{reference = TRUE}
is use, \code{invert} can be declared as a logical vector of length 2 (eg.,
\verb{invert = c(FALSE, TRUE}). In this case, the segmentation of objects and
reference from the foreground using \code{back_fore_index} is performed using the
default (not inverted), and the segmentation of objects from the reference
is performed by inverting the selection (selecting pixels higher than the
threshold).}

\item{...}{Aditional arguments passed on to \link{analyze_objects}.}
}
\value{
An object of class \code{anal_obj}. See more details in the \code{Value}
section of \code{\link[=analyze_objects]{analyze_objects()}}.
}
\description{
Analyzes objects using shapefiles
}
\details{
The \code{analyze_objects_shp} function performs object analysis on an
image and generates shapefiles representing the analyzed objects. The
function first prepares the image for analysis using the \code{\link[=image_prepare]{image_prepare()}}
function if the \code{prepare} argument is set to \code{TRUE}. If a shapefile object is
provided, the number of rows and columns for splitting the image is obtained
from the shapefile. Otherwise, the image is split into multiple sub-images
based on the specified number of rows and columns using the
\code{\link[=object_split_shp]{object_split_shp()}} function. The objects in each sub-image are analyzed
using the \code{\link[=analyze_objects]{analyze_objects()}} function, and the results are stored in a list.
If parallel processing is enabled, the analysis is performed in parallel
using multiple workers.

The output object provides access to various components of the analysis
results, such as the analyzed object coordinates and properties.
Additionally, the shapefiles representing the analyzed objects are included
in the output object for further analysis or visualization.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)

# Computes the DGCI index for each flax leaf
flax <- image_pliman("flax_leaves.jpg", plot =TRUE)
res <-
   analyze_objects_shp(flax,
                       nrow = 3,
                       ncol = 5,
                       plot = FALSE,
                       object_index = "DGCI")
plot(flax)
plot(res$shapefiles)
plot_measures(res, measure = "DGCI")
}
}
