% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aliases.R
\name{pipe_run_step}
\alias{pipe_run_step}
\title{Run specific step}
\usage{
pipe_run_step(
  pip,
  step,
  upstream = TRUE,
  downstream = FALSE,
  cleanUnkept = FALSE
)
}
\arguments{
\item{pip}{\code{Pipeline} object}

\item{step}{\code{string} name of step}

\item{upstream}{\code{logical} if \code{TRUE}, run all dependent upstream
steps first.}

\item{downstream}{\code{logical} if \code{TRUE}, run all depdendent
downstream afterwards.}

\item{cleanUnkept}{\code{logical} if \code{TRUE} all output that was not
marked to be kept is removed after the pipeline run. This option
can be useful if temporary results require a lot of memory.}
}
\value{
returns the \code{Pipeline} object invisibly
}
\description{
Run given pipeline step possibly together with
upstream and/or downstream dependencies.
}
\examples{
p <- pipe_new("pipe", data = 1)
pipe_add(p, "add1", \(x = ~data, y = 1) x + y)
pipe_add(p, "add2", \(x = ~add1, z = 2) x + z)
pipe_add(p, "mult", \(x = ~add1, y = ~add2) x * y)
pipe_run_step(p, "add2")

pipe_run_step(p, "add2", downstream = TRUE)

pipe_run_step(p, "mult", upstream = TRUE)
}
