% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin.R
\name{pin_find}
\alias{pin_find}
\title{Find Pin}
\usage{
pin_find(text = NULL, board = NULL, ...)
}
\arguments{
\item{text}{The text to find in the pin description or name.}

\item{board}{The board name used to find the pin.}

\item{...}{Additional parameters.}
}
\description{
Find a pin in any board registered using \code{board_register()}.
}
\details{
\code{pin_find()} allows you to discover new resources or retrieve
pins you've previously created with \code{pin()}.

The \code{pins} package comes with a CRAN packages board which
allows searching all CRAN packages; however, you can add additional
boards to search from like Kaggle, Github and RStudio Connect.

For 'local' and 'packages' boards, the 'text' parameter searches
the title and description of a pin using a regular expression. Other
boards search in different ways, most of them are just partial matches,
please refer to their documentation to understand how other
boards search for pins.

Once you find a pin, you can retrieve with \code{pin_get("pin-name")}.
}
\examples{
library(pins)

# retrieve pins
pin_find()

# search pins related to 'cars'
pin_find("cars")

# search pins related to 'seattle' in the 'packages' board
pin_find("seattle", board = "packages")

# search pins related to 'london' in the 'packages' board
pin_find("london", board = "packages")

\donttest{
# retrieve 'hpiR/seattle_sales' pin
pin_get("hpiR/seattle_sales")

# retrieve 'bsamGP/London.Mortality' pin
pin_get("bsamGP/London.Mortality")
}

}
