% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/has.intercept.R
\docType{methods}
\name{has.intercept}
\alias{has.intercept}
\alias{has.intercept,character-method}
\alias{has.intercept,formula-method}
\alias{has.intercept,pim-method}
\alias{has.intercept,pim.formula-method}
\alias{has.intercept,terms-method}
\title{Check whether formula has an explicit intercept}
\usage{
has.intercept(x)

\S4method{has.intercept}{character}(x)

\S4method{has.intercept}{formula}(x)

\S4method{has.intercept}{terms}(x)

\S4method{has.intercept}{pim.formula}(x)

\S4method{has.intercept}{pim}(x)
}
\arguments{
\item{x}{either a \code{formula}, \code{pim.formula}, \code{terms.object}
or a character vector representing a formula.}
}
\value{
a single logical value
}
\description{
This function checks whether an intercept is present in a formula of
some form. It works for a \code{\link[stats]{formula}}, a 
\code{\link[stats]{terms.object}} a \code{\link{pim.formula}} object or 
a character vector representing a formula.
}
\details{
In case of a \code{terms.object}, this function only checks whether the
\code{intercept} attribute is larger than 0. In all other cases, the 
function checks whether it can find a \code{+ 1} somewhere in the formula,
indicating that an intercept has to be fit in a \code{\link{pim}}.
}
\note{
This function is meant to be used in the context of a \code{\link{pim}}
call. Although the function should work for standard formulas as well,
correct results are not guaranteed when used outside a pim context.
}
\section{WARNING}{
 This function will return \code{FALSE} for a standard formula
that is used in the context of a marginal model. Keep in mind that when
specifying \code{model = 'marginal'} in a call to \code{pim}, the model
will contain an intercept regardless of the outcome of \code{has.intercept}
}
\examples{
data("FEVData")
# Create the "model frame"
FEVenv <- new.pim.env(FEVData, compare="unique")
# create the formula and bind it to the pim.environment.
FEVform <- new.pim.formula(
  Age ~ I(L(Height) - R(Height))  ,
  FEVenv
)
has.intercept(FEVform)
FEVform2 <- new.pim.formula(Age ~ Height + 1, FEVData)
has.intercept(FEVform2)

}

