% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\name{inferAlleleClusters}
\alias{inferAlleleClusters}
\title{Allele similarity cluster}
\usage{
inferAlleleClusters(
  germline_set,
  trim_3prime_side = 318,
  mask_5prime_side = 0,
  family_threshold = 75,
  allele_cluster_threshold = 95,
  cluster_method = "complete",
  aa_set = FALSE
)
}
\arguments{
\item{germline_set}{Either a character vector of strings representing Ig sequence alleles, or a path to to the germline set file (must be gapped by IMGT scheme for optimal results).}

\item{trim_3prime_side}{To which nucleotide position to trim the sequences. Default is 318; NULL will take the entire sequence length.}

\item{mask_5prime_side}{Mimic short sequence libraries, gets the length of nucleotides to mask from the 5' side, the staring position. Default is 0.}

\item{family_threshold}{The similarity threshold for the family level. Default is 75.}

\item{allele_cluster_threshold}{The similarity threshold for the allele cluster level. Default is 95.}

\item{cluster_method}{The hierarchical clustering method to use. Default is "complete".}

\item{aa_set}{Logical (FALSE by default). If the string set is of amino acid sequences.}
}
\value{
An object of type \link{GermlineCluster} that includes the following slots:
}
\description{
A wrapper function to infer the allele clusters. See details for cluster inference
}
\details{
The distance between pairs of the alleles germline set sequences is calculated, then the alleles are clustered based on two similarity thresholds.
One for the family cluster and the other for the allele cluster. Then the new allele cluster names are generated and the germline set sequences are renamed and duplicated alleles are removed.

The allele cluster names are by the following scheme:
IGHVF1-G1*01 - IGH = chain, V = region, F1 = family cluster numbering,
G1 - allele cluster numbering, and 01 = allele numbering (given by clustering order, no connection to the expression)

To plot the allele clusters dendrogram use the \code{plot} function on the \link{GermlineCluster} object
}
\section{Slots}{

\describe{
\item{\code{germlineSet}}{\itemize{
\item A character vector with the modified germline set (3' trimming and 5' masking).
}}

\item{\code{alleleClusterSet}}{\itemize{
\item A character vector of renamed input germline set to the ASC name scheme (Without 3' and 5' modifications).
}}

\item{\code{alleleClusterTable}}{\itemize{
\item A data.frame of the allele similarity cluster with the new names and the default thresholds.
}}

\item{\code{threshold}}{\itemize{
\item A list of the input family and allele cluster similarity thresholds.
}}

\item{\code{hclustAlleleCluster}}{\itemize{
\item An hclust object of the germline set hierarchical clustering,
}}
}}

\examples{

# load the initial germline set
\donttest{
data(HVGERM)

germline <- HVGERM[!grepl("^[.]", HVGERM)]

asc <- inferAlleleClusters(germline)

## plotting the clusters

plot(asc)
}
}
\seealso{
By using the plot function on the returned object, a colorful visualization of the allele clusters dendrogram and threshold is received
}
