% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_genotype.R
\name{inferGenotypeAllele}
\alias{inferGenotypeAllele}
\title{Allele similarity cluster based genotype inference}
\usage{
inferGenotypeAllele(
  data,
  alleleClusterTable,
  v_call = "v_call",
  single_assignment = FALSE,
  germline_db = NA,
  find_unmutated = FALSE,
  seq = "sequence_alignment"
)
}
\arguments{
\item{data}{data.frame in AIRR format, containing V allele calls from a single subject and the sample IMGT-gapped V(D)J sequences under seq.}

\item{alleleClusterTable}{A data.frame of the allele similarity clusters thresholds.}

\item{v_call}{name of the V allele call column. Default is \code{v_call}}

\item{single_assignment}{if TRUE, the method only considers sequence with single assignment for the genotype inference.}

\item{germline_db}{named vector of sequences containing the germline sequences named in V allele calls and the alleleClusterTable. Only required if find_unmutated is TRUE.}

\item{find_unmutated}{if TRUE, use germline_db to find which samples are unmutated. Not needed if V allele calls only represent unmutated samples.}

\item{seq}{name of the column in data with the aligned, IMGT-numbered, V(D)J nucleotide sequence. Default is sequence_alignment.}
}
\value{
A a data.frame with the inferred V genotype. The table contains the following columns:\tabular{llllllll}{
   gene \tab alleles \tab imgt_alleles \tab counts \tab absolute_fraction \tab absolute_threshold \tab genotyped_alleles \tab genotype_imgt_alleles \cr
   allele cluster \tab the present alleles \tab the imgt nomenclature \tab the number of reads \tab the absolute fraction \tab the population driven allele \tab the alleles which \tab the imgt nomenclature \cr
    \tab in the repertoire \tab of the alleles \tab for each alleles \tab of the alleles \tab thresholds for genotype presence \tab entered the genotype \tab of the alleles \cr
}
}
\description{
\code{inferGenotypeAllele} infer an individual's genotype based on the allele-base method.
The method utilize the allele specific threshold to determine the presence of an allele in the genotype.
More specifically, the absolute frequency of each allele is calculated and checked against the threshold.
}
\details{
In naive repertoires, allele calls where more than one assignment is assigned is rare. Hence, in case the data represents the naive repertoire of a subject
it is recommended to use the \code{find_unmutated=TRUE} option, to remove mutated sequences. For non-naive population, the allele calls in cases of multiple assignment
are treated as belonging to all groups.
}
\examples{


# loading TIgGER AIRR-seq b cell data
data <- tigger::AIRRDb

# preferably obtain the latest ASC cluster table
# asc_archive <- recentAlleleClusters(doi="10.5281/zenodo.7429773", get_file = TRUE)

# allele_cluster_table <- extractASCTable(archive_file = asc_archive)

# example allele similarity cluster table
data(allele_cluster_table)

data(HVGERM)

# reforming the germline set
asc_germline <- germlineASC(allele_cluster_table, germline = HVGERM)

# assigning the ASC alleles
asc_data <- assignAlleleClusters(data, allele_cluster_table)

# inferring the genotype
asc_genotype <- inferGenotypeAllele(
data = asc_data,
alleleClusterTable = allele_cluster_table,
germline_db = asc_germline, find_unmutated=TRUE)


}
\seealso{
\link{inferAlleleClusters} will infer the allele clusters based on a supplied V reference set and set the default allele threshold of 1e-04.
See \link{recentAlleleClusters} to obtain the latest version of the IGHV allele clusters and the naive population based allele threshold.
}
