% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pb_upload.R
\name{pb_upload}
\alias{pb_upload}
\title{Upload data to an existing release}
\usage{
pb_upload(
  file,
  repo = guess_repo(),
  tag = "latest",
  name = NULL,
  overwrite = "use_timestamps",
  use_timestamps = NULL,
  show_progress = getOption("piggyback.verbose", default = TRUE),
  .token = gh::gh_token(),
  dir = NULL
)
}
\arguments{
\item{file}{path to file to be uploaded}

\item{repo}{Repository name in format "owner/repo". Will guess the current
repo if not specified.}

\item{tag}{tag for the GitHub release to which this data should be attached.}

\item{name}{name for uploaded file. If not provided will use the basename of
\code{file} (i.e. filename without directory)}

\item{overwrite}{overwrite any existing file with the same name already
attached to the on release? Default behavior is based on timestamps,
only overwriting those files which are older.}

\item{use_timestamps}{DEPRECATED.}

\item{show_progress}{logical, show a progress bar be shown for uploading?
Defaults to \code{TRUE} - can also set globally with options("piggyback.verbose")}

\item{.token}{GitHub authentication token, see \verb{[gh::gh_token()]}}

\item{dir}{directory relative to which file names should be based, defaults to NULL for current working directory.}
}
\description{
NOTE: you must first create a release if one does not already exists.
}
\examples{
\dontrun{
# Needs your real token to run

readr::write_tsv(mtcars,"mtcars.tsv.xz")
pb_upload("mtcars.tsv.xz", "cboettig/piggyback-tests")
}
}
