% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multigroup.R
\name{multigroup}
\alias{multigroup}
\title{Multigroup Analysis for Piecewise SEM}
\usage{
multigroup(
  modelList,
  group,
  standardize = "scale",
  standardize.type = "latent.linear",
  test.type = "III"
)
}
\arguments{
\item{modelList}{a list of structural equations}

\item{group}{the name of the grouping variable in quotes}

\item{standardize}{The type of standardization: \code{none}, \code{scale}, \code{range}.
Default is \code{scale}.}

\item{standardize.type}{The type of standardized for non-Gaussian responses:
\code{latent.linear}, \code{Menard.OE}. Default is \code{latent.linear}.}

\item{test.type}{what kind of ANOVA should be reported. Default is type III}
}
\description{
Multigroup Analysis for Piecewise SEM
}
\examples{
data(meadows)

jutila <- psem(
lm(rich ~ elev + mass, data = meadows),
lm(mass ~ elev, data = meadows)
)

jutila.multigroup <- multigroup(jutila, group = "grazed")

jutila.multigroup

}
\author{
Jon Lefcheck <lefcheckj@si.edu>
}
