% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psem.R
\name{psem}
\alias{psem}
\title{Fitting piecewise structural equation models}
\usage{
psem(..., data)
}
\arguments{
\item{\dots}{A list of structural equations.}

\item{data}{A \code{data.frame} used to fit the equations.}
}
\value{
Returns an object of class \code{psem}.
}
\description{
\code{psem} is used to unite a list of structural equations into a single
structural equation model.
}
\details{
\code{psem} takes a list of structural equations, which can be model objects
of classes: \code{lm, glm, gls, pgls, sarlm, lme, glmmPQL, lmerMod,
merModLmerTest, glmerMod}.

It also takes objects of class \code{formula, formula.cerror}, corresponding
to additional variables to be included in the tests of directed separation
(\code{X ~ 1}) or correlated errors (\code{X1 \%~~\% X2}).

The function optionally accepts data objects of classes: \code{matrix,
data.frame, SpatialPointsDataFrame, comparative.data}, or these are derived
internally from the structural equations.
}
\seealso{
\code{\link{summary.psem}}, \code{\link{\%~~\%}}
}
\author{
Jon Lefcheck <jlefcheck@bigelow.org>
}
