\name{anc.Bayes}
\alias{anc.Bayes}
\title{Bayesian ancestral character estimation}
\usage{
anc.Bayes(tree, x, ngen=10000, control=list())
}
\arguments{
	\item{tree}{an object of class \code{"phylo"}.}
	\item{x}{a vector of tip values for species; \code{names(x)} should be the species names.}
	\item{ngen}{a integer indicating the number of generations for the MCMC.}
	\item{control}{a list of control parameters containing the following elements: \code{sig2}: starting value for \eqn{\sigma^2} (BM rate); \code{a}: starting for the state at the root node; \code{y}: starting values for the states at all internal nodes excluding the root (should be labeled with node numbers); \code{pr.mean}: means for the prior distributions in the following order - \code{sig2}, \code{a}, \code{y}, note that the prior probability distribution is exponential for \code{sig2} and normal for \code{a} and \code{y}; \code{pr.var}: variances on the prior distributions, same order as \code{pr.mean} (but the variance is not used for \code{sig2}); \code{prop}: variances on the normal proposal distributions in the same order as \code{pr.mean}; \code{sample}: sample frequency from the MCMC.}
}
\description{
	This function uses Bayesian MCMC to sample from the posterior distribution for the states at internal nodes in the tree.
}
\value{
	A matrix with number of rows \code{ngen/sample+1} containing the posterior sample and likelihoods.  Matrix columns are labeled either \code{sig2} or by the node number of the internal node.
}
\author{Liam Revell \email{liam.revell@umb.edu}}
\seealso{
	\code{\link{ace}}, \code{\link{anc.ML}}, \code{\link{anc.trend}}, \code{\link{evol.rate.mcmc}}, \code{\link{fastAnc}}
}
\examples{
tree<-rtree(50)
x<-fastBM(tree,sig2=2) # simulate using fastBM
X<-anc.Bayes(tree,x,ngen=10000) # sample ancestral states
estimates<-colMeans(X[21:nrow(X),]) # get estimates, excluding burnin
}
\keyword{phylogenetics}
\keyword{comparative method}
\keyword{bayesian}
