\name{posterior.evolrate}
\alias{posterior.evolrate}
\title{Analysis of the posterior sample from evol.rate.mcmc}
\usage{
	posterior.evolrate(tree, ave.shift, mcmc, tips, showTree=FALSE)
}
\arguments{
	\item{tree}{a phylogenetic tree in \code{"phylo"} format.}
	\item{ave.shift}{mean or median shift-point from the posterior sample (see \code{\link{minSplit}}.}
	\item{mcmc}{matrix \code{$mcmc} from \code{evol.rate.mcmc} (probably with burnin excluded).}
	\item{tips}{list of stips in state sig(1)^2 for each sampled generation of MCMC.}
	\item{showTree}{optional logical value indicating whether or not to plot the stretched and shrunken tree generated by the pre-processing algorithm implemented in this function (default is \code{FALSE}).}
}
\description{
	This fucntion takes a phylogenetic tree, an average split position, and a raw MCMC output from \code{evol.rate.mcmc} and returns a posterior sample of evolutionary rates rootward (\eqn{\sigma(1)^2}) and tipward (\eqn{\sigma(2)^2}) from the average split.
}
\value{
	a matrix containing the posterior sample of evolutionary rates and shift-points between rates.
}
\references{
	Revell, L. J., D. L. Mahler, P. Peres-Neto, and B. D. Redelings. 2012. A new method for identifying exceptional phenotypic diversification. \emph{Evolution}, \bold{66}, 135-146.
}
\author{Liam Revell \email{liam.revell@umb.edu}}
\seealso{
	\code{\link{evol.rate.mcmc}}, \code{\link{minSplit}}
}
\keyword{phylogenetics}
\keyword{comparative method}
\keyword{bayesian}
