% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloSignal.R
\name{phyloSignal}
\alias{phyloSignal}
\title{Computes phylogenetic signal with different methods}
\usage{
phyloSignal(p4d, methods = c("all", "I", "Cmean", "Lambda", "K",
  "K.star"), reps = 999, W = NULL)
}
\arguments{
\item{p4d}{a \code{phylo4d} object.}

\item{methods}{a character vector giving the methods to compute phylogenetic signal (see Details).}

\item{reps}{an integer. The number of repetitions for the estimation of p.values with randomization.}

\item{W}{an optional matrix of phylogenetic weights to compute Moran's I. By default the matrix
is computed with the function \code{\link[adephylo]{proxTips}} with patristic distances.}
}
\value{
A list of two dataframes with the values of statistics and associated
p.values for each tested trait and method.
}
\description{
This function computes phylogenetic signal statistics
(Blomberg's K and K*, Abouheif's Cmean, Moran's I, and Pagel's Lambda) for traits in \code{phylo4d} objects.
}
\details{
p4d must be a \code{phylo4d} object as defined in \pkg{phylobase} package.
By default, the \code{methods} argument is set to "\code{all}" and all the available methods are used.
The user can specify which method(s) to use. Possible methods are
"\code{I}" (Gittleman & Kot 1990), "\code{Cmean}" (Abouheif 1999)", "\code{Lambda}" (Pagel 1999),
"\code{K}" and "\code{K.star}" (Blomberg et al. 2003).
}
\examples{
require(ape)
require(phylobase)
data(navic)
tipData(navic)$rand <- rnorm(17)
tipData(navic)$BM <- rTraitCont(as(navic, "phylo"))
phyloSignal(navic)

}
\references{
Abouheif E. (1999) A method for testing the assumption of phylogenetic independence in comparative data. Evolutionary Ecology Research 1, 895-909.
Blomberg S.P., Garland Jr T. & Ives A.R. (2003) Testing for phylogenetic signal in comparative data: behavioral traits are more labile. Evolution 57, 717-745.
Gittleman J.L. & Kot M. (1990) Adaptation: Statistics and a null model for estimating phylogenetic effects. Systematic Biology 39, 227-241.
Pagel M. (1999) Inferring the historical patterns of biological evolution. Nature 401, 877-884.
Revell L.J. (2012) phytools: an R package for phylogenetic comparative biology (and other things). Methods in Ecology and Evolution 3, 217-223.
Pavoine S. & Ricotta C. (2013) Testing for Phylogenetic Signal in Biological Traits: The Ubiquity of Cross-Product Statistics. Evolution 67, 828-840.
}
\seealso{
\code{\link{phyloSimSignal}} .
}
\author{
This function is a general wrapper for C++ subroutines.
C++ code is adapted from R functions in Pavoine and Ricotta (2013)
and Revell (2012).
}
