% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_phylosem.R
\name{compare_phylosem}
\alias{compare_phylosem}
\title{Compare phylogenetic structural equation models}
\usage{
compare_phylosem(
  sem_set,
  tree,
  data,
  family = rep("fixed", ncol(data)),
  covs,
  estimate_ou = FALSE,
  estimate_lambda = FALSE,
  estimate_kappa = FALSE,
  control = phylosem_control(),
  ...
)
}
\arguments{
\item{sem_set}{A named list of structural equation model specifications,
where each element will be passed as argument \code{sem} to
\code{\link{phylosem}}}

\item{tree}{phylogenetic structure, using class \code{\link[ape]{as.phylo}}}

\item{data}{data-frame providing variables being modeled.  Missing values are inputted
as NA.  If an SEM includes a latent variable (i.e., variable with no available measurements)
then it still must be inputted as a column of \code{data} with entirely NA values.}

\item{family}{Character-vector listing the distribution used for each column of \code{data}, where
each element must be \code{fixed}, \code{normal}, \code{binomial}, or \code{poisson}.
\code{family="fixed"} is default behavior and assumes that a given variable is measured exactly.
Other options correspond to different specifications of measurement error.}

\item{covs}{optional: a character vector of one or more elements, with each element
  	giving a string of variable names, separated by commas. Variances and covariances
  	among all variables in each such string are added to the model. For confirmatory
  	factor analysis models specified via \code{cfa}, \code{covs} defaults to all of
  	the factors in the model, thus specifying all variances and covariances among these factors.
  	\emph{Warning}: \code{covs="x1, x2"} and \code{covs=c("x1", "x2")} are \emph{not}
  	equivalent: \code{covs="x1, x2"} specifies the variance of \code{x1}, the variance
  	of \code{x2}, \emph{and} their covariance, while \code{covs=c("x1", "x2")} specifies
  	the variance of \code{x1} and the variance of \code{x2} \emph{but not} their covariance.}

\item{estimate_ou}{Boolean indicating whether to estimate an autoregressive (Ornstein-Uhlenbeck)
process using additional parameter \code{lnalpha},
corresponding to the \code{model="OUrandomRoot"} parameterization from \pkg{phylolm}
as listed in \doi{10.1093/sysbio/syu005}}

\item{estimate_lambda}{Boolean indicating whether to estimate additional branch lengths for
phylogenetic tips (a.k.a. the Pagel-lambda term) using additional parameter \code{logitlambda}}

\item{estimate_kappa}{Boolean indicating whether to estimate a nonlinear scaling of branch
lengths (a.k.a. the Pagel-kappa term) using additional parameter \code{lnkappa}}

\item{control}{Output from \code{\link{phylosem_control}}, used to define user
settings, and see documentation for that function for details.}

\item{...}{Additional arguments passed to \code{\link{phylosem}}}
}
\value{
An object (list) of class `compare_phylosem`, containing a list of
        output from \code{\link{phylosem}}
}
\description{
Fits several phylogenetic structural equation model for further comparison
}
