% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAG.R
\name{est_DAG}
\alias{est_DAG}
\title{Add standardized path coefficients to a DAG.}
\usage{
est_DAG(DAG, data, cor_fun, tree)
}
\arguments{
\item{DAG}{A directed acyclic graph, typically created with \code{DAG}.}

\item{data}{A \code{data.frame} with data.}

\item{cor_fun}{A function that creates a \code{corStruct} object, typically
one of the cor function from the \code{ape}, such as \code{corBrownian},
\code{corPagel} etc.}

\item{tree}{A phylogenetic tree of class \code{pylo}.}
}
\value{
An object of class \code{fitted_DAG}.
}
\description{
Add standardized path coefficients to a DAG.
}
\examples{
  d <- DAG(LS ~ BM, NL ~ BM, DD ~ NL + LS)
  plot(d)
  d_fitted <- est_DAG(d, rhino, ape::corBrownian, rhino_tree)
  plot(d_fitted)
}

