% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{read.dendrogram}
\alias{read.dendrogram}
\title{Read a dendrogram from parenthetic text.}
\usage{
read.dendrogram(file = "", text = NULL, edges = TRUE, ...)
}
\arguments{
\item{file}{character string giving a valid path to the file from
where to read the data.}

\item{text}{optional character string in lieu of a "file" argument.
If a text argument is provided instead of a file path, the data
are read via a text connection.}

\item{edges}{logical indicating whether edge weights
provided in the Newick string should be retained in the returned
object (defaults to TRUE).}

\item{...}{further arguments to be passed to \code{scan}.}
}
\value{
Returns an object of class \code{"dendrogram"}.
}
\description{
\code{read.dendrogram} parses a text file or character string in Newick
  (New Hampshire) format and creates an object of class \code{"dendrogram"}.
}
\details{
There are varying interpretations of the Newick/New Hampshire text format.
  This function tries to adhere to the Felsenstein standard outlined
  \href{http://evolution.genetics.washington.edu/phylip/newicktree.html}{here}.
  The function supports weighted edges, labels with special
  metacharacters (enclosed in single quotation marks),
  comments (enclosed in square brackets; ignored by the parser),
  multifuricating nodes, and both rooted and unrooted trees.
  Comments enclosed in square brackets are also discarded.
  Inner-node labels (for example
  "(B:6.0,(A:5.0,C:3.0,E:4.0)Ancestor1:5.0,D:11.0);");
  are also currently ignored; however, the parsing
  of “label” attributes for non-leaf dendrogram nodes will be
  available in a future version.
}
\examples{
  newick <- "(A:0.1,B:0.2,(C:0.3,D:0.4):0.5);"
  x <- read.dendrogram(text = newick)
  plot(x, horiz = TRUE)
}
\references{
\url{http://evolution.genetics.washington.edu/phylip/newicktree.html}
  \url{http://evolution.genetics.washington.edu/phylip/newick_doc.html}
}
\seealso{
\code{\link{write.dendrogram}} writes an object of
  class \code{"dendrogram"} to a text string.
  The \code{\link[ape]{read.tree}} function in the
  \code{\link[ape]{ape}} package performs a similar operation for objects
  of class \code{"phylo"} and \code{"multiPhylo"}.
}
\author{
Shaun Wilkinson
}
