% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylotree.R
\name{phylotree}
\alias{phylotree}
\title{Maximum clade credibility tree.}
\usage{
phylotree(phybreak.object, samplesize = Inf, support = c("proportion",
  "count"), phylo.class = FALSE)
}
\arguments{
\item{phybreak.object}{An object of class \code{phybreak}.}

\item{samplesize}{The number of posterior samples that is used, taken from the tail.}

\item{support}{Whether to return the support (= posterior probability) for each infector as a \code{"proportion"} 
or as a \code{"count"} of posterior trees in which that transmission link or transmission cluster is present.}

\item{phylo.class}{Whether to return an object of class \code{"phylo"}, in which case a single tree from the 
posterior is returned (not with summary infection times).}
}
\value{
A \code{data.frame} with per item (=node) its parent and support per clade, and optionally summary node times. 
  The first n nodes are the samples, the last n-1 nodes are the internal nodes.
}
\description{
Identify the maximum clade credibility tree from a \code{phybreak}-object containing posterior samples.
}
\examples{
#First build a phybreak-object containing samples.
simulation <- sim.phybreak(obsize = 5)
MCMCstate <- phybreak(data = simulation$sequences, times = simulation$sample.times)
MCMCstate <- burnin.phybreak(MCMCstate, ncycles = 20)
MCMCstate <- sample.phybreak(MCMCstate, nsample = 50, thin = 2)

phylotree(MCMCstate)
plot(phylotree(MCMCstate, phylo.class = TRUE))
}
\references{
\href{http://dx.doi.org/10.1371/journal.pcbi.1005495}{Klinkenberg et al. (2017)} Simultaneous 
  inference of phylogenetic and transmission trees in infectious disease outbreaks. 
  \emph{PLoS Comput Biol}, \strong{13}(5): e1005495.
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
