\name{vowelsynth}
\alias{vowelsynth}
\title{
Vowel Synthesis
}
\description{
Create synthetic vowels using a cascade formant synthesizer. 
}
\usage{
vowelsynth (ffs = c(270, 2200, 2800, 3400, 4400), fbw = 0.06, 
dur = 300, f0 = c(120,100),fs = 10000, verify = FALSE, 
returnsound = TRUE, noise1 = .001, noise2 = .01, power = NULL)
}
\arguments{
  \item{ffs}{A vector of center frequencies for each formant. For moving formants, a list containing two vectors may be provided, where the first vector indicates intitial values, and the final vector indicates final values. Formant frequencies should be provided in order of lowest to highest frequency.}   
  \item{fbw}{A vector of formant bandwidths for each formant. See details for more information.} 
  \item{dur}{The desired duration of the sound, in milliseconds. Vowels must be at least 50 ms long.}   
  \item{f0}{The desired f0 (pitch) of the sound. Optionally, a vector with initial and final f0 values may be provided.}   
  \item{fs}{The desired sampling frequency of the output sound.}   
  \item{verify}{If TRUE, the waveform and spectrogram of the created sound are plotted to allow the user to visually verify the process.}   
  \item{returnsound}{If TRUE, the sound is returned as a sound object, which can be used with several other functions included in this package. If FALSE, only a vector representing the sound wave is returned.} 
  \item{noise1}{Noise to be added to the source, before formant filtering, as a proportion of the source RMS amplitude.}  
  \item{noise2}{Noise to be added to the output, as a proportion of the signal RMS amplitude.}  
  \item{power}{A desired power contour can be specified. Must be of the same length as the output sound, or the sound is truncated to the length of this vector.}     
}
\details{
This function is a Klatt-style cascade formant synthesizer that is intended to create synthetic vowel sounds. The voice source is generated using the KLGLOTT88 method described in Klatt (1988).

If the vowels sound too 'robotic', there may be formants too close to the Nyquist frequency. Conversely, if the vowels sound too 'muffled', you may need to add more formants, and make sure they extend closer to the Nyquist frequency. Vowels sound more natural when f0 is not static.  

Formant bandwidths may be provided in Hz, or as a percentage of the formant frequencies. To set these as a percent of formant frequencies, all values must be less than 1. If these are not provided they are set to 6 percent of the formant center frequencies by default. If only one value is provided, this is assumed to be the desired value for all formants.
}
\value{
A vector or 'sound' object representing the filtered sound.
}
\references{
Klatt, D. H. (1980). Software for a cascade/parallel formant synthesizer. Journal of the Acoustical Society of America 67(3): 971-995.

Klatt, D. H. (1988). Klattalk: The conversion of English text to speech. Unpublished Manuscript. Massachusetts Institute of Technology, Cambridge, MA. Chapter 3.

}
\author{
Santiago Barreda <sbarreda@ucdavis.edu>
}
\examples{

## uncomment to run

## The following examples are based on my vowels 
i = vowelsynth (returnsound = FALSE, f0 = c(125,105))
#a = vowelsynth (ffs = c(700, 1300, 2300, 3400, 4400), 
#returnsound = FALSE, f0 = c(125,105))
#e = vowelsynth (ffs = c(400, 2000, 2600, 3400, 4400), 
#returnsound = FALSE, f0 = c(125,105))
#o = vowelsynth (ffs = c(400, 900, 2300, 3400, 4400), 
#returnsound = FALSE, f0 = c(125,105))
#u = vowelsynth (ffs = c(300, 750, 2300, 3400, 4400), 
#returnsound = FALSE, f0 = c(125,105))

#silence = rep(0, 1000)
#vowels = c(a, silence, e, silence, i, silence, o, silence, u)

#writesound (vowels, filename = 'vowels.wav', fs = 10000)

## an example of a synthetic diphthong
#ei = vowelsynth (ffs = list(c(400, 2000, 2600, 3400, 4400), 
#c(270, 2200, 2800, 3400, 4400)), f0 = c(125,105))
#writesound (ei)
#spectrogram (ei, pause = FALSE)

}

