% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gJSD.R
\name{gJSD}
\alias{gJSD}
\title{Generalized Jensen-Shannon Divergence}
\usage{
gJSD(x, unit = "log2", weights = NULL)
}
\arguments{
\item{x}{a probability matrix.}

\item{unit}{a character string specifying the logarithm unit that shall be used to compute distances that depend on log computations.}

\item{weights}{a numeric vector specifying the weights for each distribution in \code{x}. 

Default: \code{weights} = \code{NULL}; in this case all distributions are weighted equally.}
}
\value{
The Jensen-Shannon divergence between all possible combinations of comparisons.
}
\description{
This function computes the Generalized Jensen-Shannon Divergence of a probability matrix.
}
\details{
Function to compute the Generalized Jensen-Shannon Divergence
}
\examples{

Prob <- rbind(1:10/sum(1:10), 20:29/sum(20:29), 30:39/sum(30:39))

# compute the Generalized JSD comparing the PS probability matrix
gJSD(Prob)

}
\seealso{
\code{\link{KL}}, \code{\link{H}}, \code{\link{JSD}},
 \code{\link{CE}}, \code{\link{JE}}
}
\author{
Hajk-Georg Drost
}
