% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{library.size.normalize}
\alias{library.size.normalize}
\title{Performs L1 normalization on input data such that the sum of expression
values for each cell sums to 1, then returns normalized matrix to the metric
space using median UMI count per cell effectively scaling all cells as if
they were sampled evenly.}
\usage{
library.size.normalize(data, verbose = FALSE)
}
\arguments{
\item{data}{matrix (n_samples, n_dimensions)
2 dimensional input data array with n cells and p dimensions}

\item{verbose}{boolean, default=FALSE. If true, print verbose output}
}
\value{
data_norm matrix (n_samples, n_dimensions)
2 dimensional array with normalized gene expression values
}
\description{
Performs L1 normalization on input data such that the sum of expression
values for each cell sums to 1, then returns normalized matrix to the metric
space using median UMI count per cell effectively scaling all cells as if
they were sampled evenly.
}
