% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SIR.R
\name{SIR}
\alias{SIR}
\title{The SIR Epidemic Model}
\usage{
SIR(t, y, parameters)
}
\arguments{
\item{t}{The value of \ifelse{html}{\out{<i>t</i>}}{\eqn{t}}, the independent variable, to evaluate the derivative
at. Should be a single number.}

\item{y}{The values of \ifelse{html}{\out{<i>x</i>}}{\eqn{x}} and 
\ifelse{html}{\out{<i>y</i>}}{\eqn{y}}, the dependent
variables, to evaluate the derivative at. Should be a vector of length two.}

\item{parameters}{The values of the parameters of the system. Should be a vector
with parameters specified in the following order: \ifelse{html}{\out{<i>&beta;</i>}}{\eqn{\beta}}, \ifelse{html}{\out{<i>&nu;</i>}}{\eqn{\nu}}.}
}
\value{
Returns a list containing the values of the two derivatives
at \ifelse{html}{\out{(<i>t</i>, <i>x</i>, <i>y</i>)}}{\eqn{(t, x, y)}}.
}
\description{
The derivative function of the SIR Epidemic Model, an example of a two-dimensional autonomous ODE system.
}
\details{
\code{SIR} evaluates the derivative of the following ODE at the point
\ifelse{html}{\out{(<i>t</i>, <i>x</i>, <i>y</i>)}}{\eqn{(t, x, y)}}:

\ifelse{html}{\out{<center><i>dx</i>/<i>dt</i> = -<i>&beta;xy</i>,
<i>dy</i>/<i>dt</i> = <i>&beta;xy</i> - <i>&nu;y</i>.</center>}}{\deqn{\frac{dx}{dt} = -\beta xy, \frac{dy}{dt} = \beta xy - \nu y.}}

Its format is designed to be compatible with \code{\link[deSolve]{ode}} from the \code{\link[deSolve]{deSolve}} package.
}
\seealso{
\code{\link[deSolve]{ode}}
}
\author{
Michael J. Grayling
}
