% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indActogram.R
\name{indActogram}
\alias{indActogram}
\title{Plot actogram of individual fly}
\usage{
indActogram(
  data,
  bin = 30,
  t.cycle = 24,
  ind = 1,
  key.acto = 1,
  color = rgb(0, 0, 0, 1)
)
}
\arguments{
\item{data}{Input data file. The input for this function must be the output of the function binData(). See ??binData().}

\item{bin}{Define the bin size (in minutes) in which input data is saved.}

\item{t.cycle}{Define the period of the environmental cycle or a single day in hours. This defaults to 24.}

\item{ind}{The channel number (or individual) whose actogram must be plotted.}

\item{key.acto}{Key for reactive input tables in the shiny app.}

\item{color}{Color of actograms in rgb format. The input for this must be a vector with 4 values, i.e., r,g,b,transparency. The values for r,g,b can only be between 0 and 1. 0,0,0 would be black and 1,1,1 would be white. Transparency values can also go from 0 to 1, 0 being fully transparent and 1 being fully opaque.}
}
\value{
A \code{plotly} \code{htmlwidget} with the actogram of a user defined fly.
}
\description{
Allows users to generate individual actograms. The input for this function must be the output of the binData() function. The output of this function is a plotly object.
}
\examples{
\dontrun{
td <- trimData(data = df, start.date = "19 Dec 20", start.time = "21:00",
n.days = 10, bin = 1, t.cycle = 24)
bd <- binData(td)
ind.actogram <- indActogram(data = bd, bin = 30, ind = 2)
}
}
