% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pguCorrValidator.R
\name{pgu.corrValidator}
\alias{pgu.corrValidator}
\title{pgu.corrValidator}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
An R6 class that performs pairwise correlation of the features of the original and the imputed data set.
The correlation results of both data sets are compared by subtraction.
}
\section{Construction}{

x <- pguIMP::pgu.corrValidator$new()
}

\examples{
require(dplyr)
require(tibble)
data(iris)
data_df <- iris \%>\%
  tibble::as_tibble()
comp_df <- data_df \%>\%
  dplyr::mutate(Sepal.Length = sample(Sepal.Length))
corr_obj = pguIMP::pgu.corrValidator$new()
corr_obj$fit(data_df, comp_df)
print(corr_obj)

}
\author{
Sebastian Malkusch, \email{malkusch@med.uni-frankfurt.de}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{featureNames}}{Returns the instance variable featureNames.
(character)}

\item{\code{orgR_mat}}{Returns the instance variable orgR_mat.
(matrix)}

\item{\code{impR_mat}}{Returns the instance variable impR_mat.
(matrix)}

\item{\code{orgP_mat}}{Returns the instance variable orgP_mat.
(matrix)}

\item{\code{impP_mat}}{Returns the instance variable impP_mat.
(matrix)}

\item{\code{corr_df}}{Returns the instance variable corr_df.
(tibble::tibble)}

\item{\code{summary_df}}{Returns the instance variable summary_df.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{pgu.corrValidator$new()}}
\item \href{#method-print}{\code{pgu.corrValidator$print()}}
\item \href{#method-reset}{\code{pgu.corrValidator$reset()}}
\item \href{#method-fit}{\code{pgu.corrValidator$fit()}}
\item \href{#method-correlationScatterPlot}{\code{pgu.corrValidator$correlationScatterPlot()}}
\item \href{#method-correlationBarPlot}{\code{pgu.corrValidator$correlationBarPlot()}}
\item \href{#method-correlationBoxPlot}{\code{pgu.corrValidator$correlationBoxPlot()}}
\item \href{#method-correlationCompoundPlot}{\code{pgu.corrValidator$correlationCompoundPlot()}}
\item \href{#method-clone}{\code{pgu.corrValidator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Clears the heap and
indicates if instance of \code{pgu.corrValidator} is removed from heap.


Summary of the correlation deviation distribution.


Creates a square matrix which dimension corresponds to the length
of the instance variable featureNames. The matrix entries are set to a distinct \code{value}.


Flattens the results transforms them into a dataframe
and stores it into the instance variable corr_df.


Creates and returns a new \code{pgu.corrValidator} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$new(org_df = "tbl_df", imp_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{org_df}}{The original data to be analyzed.
(tibble::tibble)}

\item{\code{imp_df}}{The imputed version of the org_df data.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{pgu.corrValidator} object.
(pguIMP::pgu.corrValidator)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Prints instance variables of a \code{pgu.corrValidator} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
string
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-reset"></a>}}
\if{latex}{\out{\hypertarget{method-reset}{}}}
\subsection{Method \code{reset()}}{
Resets the object \code{pgu.corrValidator} based on the instance variable featureNames..
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$reset()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fit"></a>}}
\if{latex}{\out{\hypertarget{method-fit}{}}}
\subsection{Method \code{fit()}}{
Runs the corraltion analysis.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$fit(org_df = "tbl_df", imp_df = "tbl_df")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{org_df}}{Adataframe comprising the original data.
(tibble::tibble)}

\item{\code{imp_df}}{Adataframe comprising the imputed data.
(tibble::tibble)}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-correlationScatterPlot"></a>}}
\if{latex}{\out{\hypertarget{method-correlationScatterPlot}{}}}
\subsection{Method \code{correlationScatterPlot()}}{
Plots the correlation analysis results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$correlationScatterPlot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-correlationBarPlot"></a>}}
\if{latex}{\out{\hypertarget{method-correlationBarPlot}{}}}
\subsection{Method \code{correlationBarPlot()}}{
Creates and returns a histogram from the cor_delat values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$correlationBarPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Bar plot
(ggplot2::ggplot)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-correlationBoxPlot"></a>}}
\if{latex}{\out{\hypertarget{method-correlationBoxPlot}{}}}
\subsection{Method \code{correlationBoxPlot()}}{
Plots the correlation analysis results.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$correlationBoxPlot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-correlationCompoundPlot"></a>}}
\if{latex}{\out{\hypertarget{method-correlationCompoundPlot}{}}}
\subsection{Method \code{correlationCompoundPlot()}}{
Creates and returns a compund graphical analysis of the cor_delta values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$correlationCompoundPlot()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Compound plot
(gridExtra::grid.arrange)
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{pgu.corrValidator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
