/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources;

import java.io.File;
import java.util.logging.Logger;
import net.sf.eps2pgf.ProgramError;

public final class Utils {
    private static final String RESOURCE_DIR_NAME = "resources";
    private static File resourceDir = null;
    private static final Logger LOG = Logger.getLogger("net.sourceforge.eps2pgf");

    private Utils() {
    }

    private static File findResourceDirInPath(File file) {
        File file2;
        File file3;
        File file4 = null;
        for (File file5 = file; !(file5 == null || (file4 = new File(file5, RESOURCE_DIR_NAME)).exists() && (file3 = new File(file4, "afm")).exists() && (file2 = new File(file4, "fontdescriptions")).exists()); file5 = file5.getParentFile()) {
            file4 = null;
        }
        return file4;
    }

    public static synchronized File getResourceDir() throws ProgramError {
        if (resourceDir != null) {
            return resourceDir;
        }
        File file = new File(System.getProperty("user.dir"));
        LOG.info("Current directory = " + file.toString());
        String string = System.getProperty("java.class.path");
        LOG.info("Java class path = " + string);
        String string2 = System.getProperty("path.separator");
        int n = string.indexOf(string2);
        File file2 = n == -1 ? new File(string) : new File(string.substring(0, n));
        if (!file2.isAbsolute()) {
            file2 = new File(file, file2.getPath());
        }
        if (file2.isFile()) {
            file2 = file2.getParentFile();
        }
        File file3 = new File(file, "dist_root");
        resourceDir = Utils.findResourceDirInPath(file2);
        if (resourceDir == null) {
            resourceDir = Utils.findResourceDirInPath(file);
        }
        if (resourceDir == null) {
            resourceDir = Utils.findResourceDirInPath(file3);
        }
        if (resourceDir == null) {
            throw new ProgramError("Unable to find resource directory.");
        }
        LOG.info("Resource directory = " + resourceDir);
        return resourceDir;
    }
}

