% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools.R
\name{alterDATABASE}
\alias{alterDATABASE}
\title{Generate a PostgreSQL ALTER DATABASE statement, optionally execute the statement if con is not NULL.}
\usage{
alterDATABASE(
  name,
  allow_connections = NULL,
  connection_limit = NULL,
  is_template = NULL,
  rename_to = NULL,
  owner_to = NULL,
  set_tablespace = NULL,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "name" parameter for PostgreSQL ALTER DATABASE.}

\item{allow_connections}{A string, the "allowconn" parameter for PostgreSQL ALTER DATABASE.}

\item{connection_limit}{A string, the "connlimit" parameter for PostgreSQL ALTER DATABASE.}

\item{is_template}{A string, the "istemplate" parameter for PostgreSQL ALTER DATABASE.}

\item{rename_to}{A string, the "new_name" parameter for PostgreSQL ALTER DATABASE.}

\item{owner_to}{A string, the "new_owner" parameter for PostgreSQL ALTER DATABASE.}

\item{set_tablespace}{A string, the "new_tablespace" parameter for PostgreSQL ALTER DATABASE.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, PostgreSQL ALTER DATABASE statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a PostgreSQL ALTER DATABASE statement, optionally execute the statement if con is not NULL.
}
\examples{
alterDATABASE("dbTest01", rename_to = "dbProd01")
}
