% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{mpbandwidth}
\alias{mpbandwidth}
\title{Maximum Persistence Bandwidth}
\usage{
mpbandwidth(flamelet, scale.param)
}
\arguments{
\item{flamelet}{a kxm matrix corresponding to the Persistence Flamelet.}

\item{scale.param}{a vector of lenght m corresponding to the values of the scale parameter at which the Flamelet \code{X} has been evaluated.}
}
\value{
the value of the bandwidth corresponding to the most persistent feature of the Flamelet.
}
\description{
Select the bandwidth that maximises the persistence of the scale-family, highlighting the most prominent topological feature of the KDE.
}
\examples{
\donttest{
library(TDA)
xx = rbind(circleUnif(50, 1), circleUnif(50, 1.5) + 3)
Xlim = c(-1, 5);  Ylim = c(-1, 5);  by = 0.05
lim = cbind(Xlim, Ylim)
foo.flamelet = build.flamelet(X = xx, h.grid = seq(0.01, 1, length.out = 40),
base.type = "landscape", dimension = 1,base.param = 1, lim = lim, by = by,
                            tseq = seq(0, .75, length.out = 500))
mpband(flamelet = foo.flamelet, scale.param = seq(0.01, 1, length.out = 40))
}
}
\references{
T. Padellini and P. Brutti (2017) Persistence Flamelets: multiscale Persistent Homology for kernel density exploration \url{https://arxiv.org/abs/1709.07097}
}
