% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cbindFill.R
\name{columnBindFill}
\alias{columnBindFill}
\title{Column Bind and Fill.}
\usage{
columnBindFill(...)
}
\arguments{
\item{...}{Names of multiple dataframes.}
}
\value{
Dataframe with columns binded together.
}
\description{
Column bind dataframes and fill with \code{NA}s.
}
\details{
Binds columns of two or more dataframes together, and fills in missing rows.
}
\examples{
# Prepare Data
df1 <- data.frame(a = rnorm(5), b = rnorm(5))
df2 <- data.frame(c = rnorm(4), d = rnorm(4))

# Column Bind and Fill
columnBindFill(df1, df2)

}
\seealso{
\url{https://stackoverflow.com/questions/7962267/cbind-a-dataframe-with-an-empty-dataframe-cbind-fill/7962286#7962286}

Other dataManipulation: 
\code{\link{convert.magic}()},
\code{\link{dropColsWithAllNA}()},
\code{\link{dropRowsWithAllNA}()}
}
\concept{dataManipulation}
