% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot2WayInteraction.R
\name{plot2WayInteraction}
\alias{plot2WayInteraction}
\title{Plot 2-way interaction.}
\usage{
plot2WayInteraction(
  predictor,
  outcome,
  moderator,
  predictorLabel = "predictor",
  outcomeLabel = "outcome",
  moderatorLabel = "moderator",
  varList,
  varTypes,
  values = NA,
  interaction = "normal",
  legendLabels = NA,
  legendLocation = "topright",
  ylim = NA,
  pvalues = TRUE,
  data
)
}
\arguments{
\item{predictor}{character name of predictor variable  (variable on x-axis).}

\item{outcome}{character name of outcome variable  (variable on y-axis).}

\item{moderator}{character name of moderator variable  (variable on z-axis).}

\item{predictorLabel}{label on x-axis of plot}

\item{outcomeLabel}{label on y-axis of plot}

\item{moderatorLabel}{label on z-axis of plot}

\item{varList}{names of predictor variables in model}

\item{varTypes}{types of predictor variables in model; one of:
\itemize{
 \item \code{"mean"} = plots at mean of variable -- should be used for ALL
 covariates (apart from main predictor and moderator)
 \item \code{"sd"} = plots at +/- 1 sd of variable (for most continuous
 predictors and moderators)
 \item \code{"binary"} = plots at values of 0,1 (for binary predictors and
 moderators)
 \item \code{"full"} = plots full range of variable (for variables like age
 when on x-axis)
 \item \code{"values"} = allows plotting moderator at specific values (e.g.,
 \code{0}, \code{1}, \code{2})
 \item \code{"factor"} = plots moderator at different categories (e.g.,
 \code{TRUE}, \code{FALSE})
}}

\item{values}{specifies values at which to plot moderator (must specify
varType = \code{"values"})}

\item{interaction}{one of:
\itemize{
 \item \code{"normal"} = standard interaction
 \item \code{"meancenter"} = calculates the interaction from a mean-centered
 predictor and moderator (subtracting each individual's value from the
 variable mean to set the mean of the variable to zero)
 \item \code{"orthogonalize"} = makes the interaction orthogonal to the
 predictor and moderator by regressing the interaction on the predictor and
 outcome and saving the residual
}}

\item{legendLabels}{vector of 2 labels for the two levels of the moderator;
leave as \code{NA} to see the actual levels of the moderator}

\item{legendLocation}{one of: \code{"topleft"}, \code{"topright"},
\code{"bottomleft"}, or \code{"bottomright"}}

\item{ylim}{vector of min and max values on y-axis (e,g., \code{0},
\code{10})}

\item{pvalues}{whether to include p-values of each slope in plot (\code{TRUE}
or \code{FALSE})}

\item{data}{name of data object}
}
\value{
Plot of two-way interaction.
}
\description{
Generates a plot of a 2-way interaction.
}
\details{
Generates a plot of a 2-way interaction: the association between a predictor
and an outcome at two levels of the moderator.
}
\examples{
# Prepare Data
predictor <- rnorm(1000, 10, 3)
moderator <- rnorm(1000, 50, 10)
outcome <- (1.7 * predictor) + (1.3 * moderator) +
  (1.5 * predictor * moderator) + rnorm(1000, sd = 3)
covariate <- rnorm(1000)
df <- data.frame(predictor, moderator, outcome, covariate)

# Linear Regression
lmModel <- lm(outcome ~ predictor + moderator + predictor:moderator,
  data = df, na.action = "na.exclude")
summary(lmModel)

# 1. Plot 2-Way Interaction
plot2WayInteraction(predictor = "predictor",
                    outcome = "outcome",
                    moderator = "moderator",
                    varList = c("predictor","moderator","covariate"),
                    varTypes = c("sd","binary","mean"),
                    data = df)

# 2. Specify y-axis Range
plot2WayInteraction(predictor = "predictor",
                    outcome = "outcome",
                    moderator = "moderator",
                    varList = c("predictor","moderator","covariate"),
                    varTypes = c("sd","binary","mean"),
                    ylim = c(10,50),                                  #new
                    data = df)

# 3. Add Variable Labels
plot2WayInteraction(predictor = "predictor",
                    outcome = "outcome",
                    moderator = "moderator",
                    varList = c("predictor","moderator","covariate"),
                    varTypes = c("sd","binary","mean"),
                    ylim = c(10,50),
                    predictorLabel = "Stress",                        #new
                    outcomeLabel = "Aggression",                      #new
                    moderatorLabel = "Gender",                        #new
                    data = df)

# 4. Change Legend Labels
plot2WayInteraction(predictor = "predictor",
                    outcome = "outcome",
                    moderator = "moderator",
                    varList = c("predictor","moderator","covariate"),
                    varTypes = c("sd","binary","mean"),
                    ylim = c(10,50),
                    predictorLabel = "Stress",
                    outcomeLabel = "Aggression",
                    moderatorLabel = "Gender",
                    legendLabels = c("Boys","Girls"),                 #new
                    data = df)

# 5. Move Legend Location
plot2WayInteraction(predictor = "predictor",
                    outcome = "outcome",
                    moderator = "moderator",
                    varList = c("predictor","moderator","covariate"),
                    varTypes = c("sd","binary","mean"),
                    ylim = c(10,50),
                    predictorLabel = "Stress",
                    outcomeLabel = "Aggression",
                    moderatorLabel = "Gender",
                    legendLabels = c("Boys","Girls"),
                    legendLocation = "topleft",                       #new
                    data = df)

#6. Turn Off p-Values
plot2WayInteraction(predictor = "predictor",
                    outcome = "outcome",
                    moderator = "moderator",
                    varList = c("predictor","moderator","covariate"),
                    varTypes = c("sd","binary","mean"),
                    ylim = c(10,50),
                    predictorLabel = "Stress",
                    outcomeLabel = "Aggression",
                    moderatorLabel = "Gender",
                    legendLabels = c("Boys","Girls"),
                    legendLocation = "topleft",
                    pvalues = FALSE,                                  #new
                    data = df)

#7. Get Regression Output from Mean-Centered Predictor and Moderator
plot2WayInteraction(predictor = "predictor",
                    outcome = "outcome",
                    moderator = "moderator",
                    varList = c("predictor","moderator","covariate"),
                    varTypes = c("sd","binary","mean"),
                    ylim = c(10,50),
                    predictorLabel = "Stress",
                    outcomeLabel = "Aggression",
                    moderatorLabel = "Gender",
                    legendLabels = c("Boys","Girls"),
                    legendLocation = "topleft",
                    interaction = "meancenter",                       #new
                    data = df)

#8. Get Regression Output from Orthogonalized Interaction Term
plot2WayInteraction(predictor = "predictor",
                    outcome = "outcome",
                    moderator = "moderator",
                    varList = c("predictor","moderator","covariate"),
                    varTypes = c("sd","binary","mean"),
                    ylim = c(10,50),
                    predictorLabel = "Stress",
                    outcomeLabel = "Aggression",
                    moderatorLabel = "Gender",
                    legendLabels = c("Boys","Girls"),
                    legendLocation = "topleft",
                    interaction = "orthogonalize",                    #new
                    data = df)
}
\seealso{
Other plot: 
\code{\link{addText}()},
\code{\link{ppPlot}()},
\code{\link{vwReg}()}

Other multipleRegression: 
\code{\link{lmCombine}()},
\code{\link{ppPlot}()},
\code{\link{update_nested}()}
}
\concept{multipleRegression}
\concept{plot}
