% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset_hapMat.R
\name{subsetHapMat}
\alias{subsetHapMat}
\title{Subset hapMat}
\usage{
subsetHapMat(hapMat, SNVs)
}
\arguments{
\item{hapMat}{A \code{hapMat} object.}

\item{SNVs}{Indices of hapMat object specifying the SNVs in the neighborhood.}
}
\value{
A subset of \code{hapMat} object to be returned to \code{\link{selectWindow}}
}
\description{
This function subsets the neighborhood of the focal SNV from the \code{hapMat} object.
}
\examples{

\dontshow{

data(ex_hapMatSmall_data)

# Find the neighborhood.
fsout = findSNVs(hapMat = ex_hapMatSmall_data, focalSNV = 10, minWindow = 1)

# Subset hapMat to the selected SNV window.
subHapMat = subsetHapMat(hapMat = ex_hapMatSmall_data, fsout$SNVwindow)
}

}
\seealso{
\code{\link{selectWindow}}
}
\keyword{internal}
